<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\CreditoPlafond;
use Usoko\SIGBundle\Form\CreditoPlafondType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\NumeroReal;

/**
 * CreditoPlafond controller.
 *
 */
class CreditoPlafondController extends Controller {

    /**
     * Lists all CreditoPlafond entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:CreditoPlafond')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:CreditoPlafond:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new CreditoPlafond entity.
     *
     */
    public function createAction(Request $request) {


        $entity = new CreditoPlafond();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $entity->setValorlimite((double) $this->valor($request));
            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "CreditoPlafond", "I", "Registo de Um Novo Plafond");
            return $this->redirect($this->generateUrl('creditoplafond_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:CreditoPlafond:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a CreditoPlafond entity.
     *
     * @param CreditoPlafond $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(CreditoPlafond $entity) {
        $form = $this->createForm(new CreditoPlafondType(), $entity, array(
            'action' => $this->generateUrl('creditoplafond_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new CreditoPlafond entity.
     *
     */
    public function newAction() {
        $entity = new CreditoPlafond();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:CreditoPlafond:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a CreditoPlafond entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:CreditoPlafond')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find CreditoPlafond entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:CreditoPlafond:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing CreditoPlafond entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:CreditoPlafond')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find CreditoPlafond entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:CreditoPlafond:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a CreditoPlafond entity.
     *
     * @param CreditoPlafond $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(CreditoPlafond $entity) {
        $form = $this->createForm(new CreditoPlafondType(), $entity, array(
            'action' => $this->generateUrl('creditoplafond_update', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing CreditoPlafond entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:CreditoPlafond')->find($id);



        if (!$entity) {
            throw $this->createNotFoundException('Unable to find CreditoPlafond entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $entity->setValorLimite((double) $this->valor($request));
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "CreditoPlafond", "U", "Actualização de Um Plafond");
            return $this->redirect($this->generateUrl('creditoplafond_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:CreditoPlafond:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a CreditoPlafond entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('UsokoSIGBundle:CreditoPlafond')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find CreditoPlafond entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "CreditoPlafond", "D", "Remoção de Um plafond");
            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('creditoplafond'));
    }

    /**
     * Creates a form to delete a CreditoPlafond entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('creditoplafond_delete', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

    private function valor($request) {
        $valorLimite = $request->request->get('usoko_sigbundle_creditoplafond')['valorlimite'];
        $valorLimite = NumeroReal::converter($valorLimite);
        return $valorLimite;
    }

}
