<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\ComparticipacaoResposta;
use Usoko\SIGBundle\Form\ComparticipacaoRespostaType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\VarsGeneral;

/**
 * ComparticipacaoResposta controller.
 *
 */
class ComparticipacaoRespostaController extends Controller {

    /**
     * Lists all ComparticipacaoResposta entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:ComparticipacaoResposta')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:ComparticipacaoResposta:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new ComparticipacaoResposta entity.
     *
     */
    public function createAction(Request $request, $solicitacao, $op) {

        $em = $this->getDoctrine()->getManager();
        $solicitacaoCR = $solicitacao;
        $solicitacao = $this->get('nzo_url_encryptor')->decrypt($solicitacao);
        $solicitacao = $em->getRepository('UsokoSIGBundle:Comparticipacao')->find($solicitacao);

        $entity = new ComparticipacaoResposta();

        if (!$solicitacao) {
            throw $this->createNotFoundException('Unable to find Solicitação entity.');
        }

        if ($op == 'aprove') {
            $form = $this->createCreateForm($entity, $solicitacaoCR, $this);
            $tipo = VarsGeneral::CONS_COMP_RESPOSTA_APROVADO;
        } elseif ($op == 'deny') {
            $form = $this->createCreateFormB($entity, $solicitacaoCR, $this);
            $tipo = VarsGeneral::CONS_COMP_RESPOSTA_REPROVADO;
        }
        $form->handleRequest($request);

        $solicitacao->setEstado($tipo);
        $entity->setResposta($tipo);
        $entity->setData(\Usoko\SIGBundle\General\DataGeneral::tempoGeral());
        $entity->setComparticipacao($solicitacao);
        $associado = \Usoko\SIGBundle\General\CryptGeneral::encrypt($this, $solicitacao->getAssociado()->getId());

        //if (\Usoko\SIGBundle\General\Validacao::validar($this, $entity)) {
        if (true) {
            $em->getConnection()->beginTransaction();
            $em->persist($solicitacao);
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "ComparticipacaoResposta", "I", "Registo de Uma Comparticipação Resposta");
            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('myComparticipacao_AS', array('id' => $associado, 'play' => '22')));
        }

        return $this->redirect($this->generateUrl('myComparticipacao_AS', array('id' => $associado, 'play' => '01')));

//        return $this->render('UsokoSIGBundle:Comparticipacao:PA_LisCom.html.twig', array(
//                    'entity' => $entity,
//                    'form' => $form->createView(),
//        ));
    }

    /**
     * Creates a form to create a ComparticipacaoResposta entity.
     *
     * @param ComparticipacaoResposta $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    public function createCreateForm(ComparticipacaoResposta $entity, $solicitacao, $obj = null, $op = 'aprove') {
        if ($obj != null) {
            $form = $obj->createForm(new ComparticipacaoRespostaType(), $entity, array(
                'action' => $obj->generateUrl('comparticipacaoresposta_create', array('solicitacao' => $solicitacao, 'op' => $op)),
                'method' => 'POST',
            ));
        } else {
            $form = $this->createForm(new ComparticipacaoRespostaType(), $entity, array(
                'action' => $obj->generateUrl('comparticipacaoresposta_create', array('solicitacao' => $solicitacao, 'op' => $op)),
                'method' => 'POST',
            ));
        }

        $form->add('submit', 'submit', array('label' => 'Registar'));
        return $form;
    }

    public function createCreateFormB(ComparticipacaoResposta $entity, $solicitacao, $obj = null, $op = 'deny') {
        if ($obj == null) {
            $obj = $this;
        }
        $form = $obj->createForm(new \Usoko\SIGBundle\Form\ComparticipacaoRespostaBType(), $entity, array(
            'action' => $obj->generateUrl('comparticipacaoresposta_create', array('solicitacao' => $solicitacao, 'op' => $op)),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));

        return $form;
    }

    /**
     * Displays a form to create a new ComparticipacaoResposta entity.
     *
     */
    public function newAction() {
        $entity = new ComparticipacaoResposta();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:ComparticipacaoResposta:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a ComparticipacaoResposta entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:ComparticipacaoResposta')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find ComparticipacaoResposta entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:ComparticipacaoResposta:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing ComparticipacaoResposta entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:ComparticipacaoResposta')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find ComparticipacaoResposta entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:ComparticipacaoResposta:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a ComparticipacaoResposta entity.
     *
     * @param ComparticipacaoResposta $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(ComparticipacaoResposta $entity) {
        $form = $this->createForm(new ComparticipacaoRespostaType(), $entity, array(
            'action' => $this->generateUrl('comparticipacaoresposta_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing ComparticipacaoResposta entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();

        $entity = $em->getRepository('UsokoSIGBundle:ComparticipacaoResposta')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find ComparticipacaoResposta entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "ComparticipaçãoResposta", "U", "Actualização de Uma Comparticipação Resposta");
            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('comparticipacaoresposta_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:ComparticipacaoResposta:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a ComparticipacaoResposta entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:ComparticipacaoResposta')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find ComparticipacaoResposta entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "ComparticipaçãoResposta", "D", "Remoção de Uma Comparticipação Resposta");

            $em->remove($entity);
            $em->flush();

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('comparticipacaoresposta'));
    }

    /**
     * Creates a form to delete a ComparticipacaoResposta entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('comparticipacaoresposta_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

    public function myCompRespAction($id, $solicitacao) {


        $id = \Usoko\SIGBundle\General\CryptGeneral::decrypt($this, $id);
        $solicitacao = \Usoko\SIGBundle\General\CryptGeneral::decrypt($this, $solicitacao);

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('id' => $id, 'tipo' => VarsGeneral::CONS_ASSOCIADO_TIPO_BENETITULAR));
        //$entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);
        if (!$entity) {
            throw $this->createNotFoundException('Associado Não Encontrado .');
        }

        $resposta = $em->getRepository('UsokoSIGBundle:ComparticipacaoResposta')->findOneBy(array('comparticipacao' => $solicitacao));

        if (!$resposta) {
            throw $this->createNotFoundException(' Subsidio Não encontrado.');
        }

        return $this->render('UsokoSIGBundle:ComparticipacaoResposta:PA_DadosComRest.html.twig', array(
                    'entity' => $entity,
                    'resposta' => $resposta,
        ));
    }

    /**
     * Finds and displays a Comparticipacao entity.
     *
     */
}
