<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Comparticipacao;
use Usoko\SIGBundle\Form\ComparticipacaoType;
use Usoko\SIGBundle\General\UploadGeneral;
use Usoko\SIGBundle\General\VarsGeneral;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\DataGeneral;
use Symfony\Component\HttpFoundation\Response;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\NumeroReal;

/**
 * Comparticipacao controller.
 *
 */
class ComparticipacaoController extends Controller {

    /**
     * Lists all Comparticipacao entities.
     *
     */
    public function indexAction($cod, Request $request) {
        $em = $this->getDoctrine()->getManager();

        if ($cod == 'P') {
            $estado = 'A';
        } elseif ($cod == 'E') {
            $estado = 'R';
        } elseif ($cod == 'PX') {
            $estado = 'AP';  // Aprovado Pago
        } else {
            $estado = 'P';
        }

        $entities = $em->getRepository('UsokoSIGBundle:Comparticipacao')->findBy(array('estado' => $estado));

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Comparticipacao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
                    'estado' => $estado,
        ));
    }

    /**
     * Creates a new Comparticipacao entity.
     *
     */
    public function createAction(Request $request, $associado) {
        $valor = $this->valor($request);

        $associadoCR = $associado;
        $associado = \Usoko\SIGBundle\General\CryptGeneral::decrypt($this, $associadoCR);
        $entity = new Comparticipacao();
        $form = $this->createCreateForm($entity, $associado);
        $form->handleRequest($request);

        $em = $this->getDoctrine()->getManager();


        $associado = $em->getRepository('UsokoSIGBundle:Associado')->find($associado);
        if (!$associado) {
            throw $this->createNotFoundException('Associado Não Existe');
        }

        if ($associado->getTipo() != VarsGeneral::CONS_ASSOCIADO_TIPO_BENETITULAR) {
            throw $this->createNotFoundException('Este Associado não é um Beneficiario Titular, logo não tem acesso a subsidios');
        }
        // \Usoko\SIGBundle\General\Validacao::validar($this, $entity)
        if (true) {
            $entity->setValor((double) $valor);
            $entity->setAssociado($associado);
            $entity->setEstado(VarsGeneral::CONS_COMP_ESTADO_PENDENTE);
            $entity->setDataActual(\Usoko\SIGBundle\General\DataGeneral::tempoGeral());

            $entity->setCodigo($this->codigoGerador());
            $utilizador = $this->get('security.context')->getToken()->getUser();
            $entity->setUtilizador($utilizador);

            if ($entity->getDependente()) {
                $pertence = $em->getRepository('UsokoSIGBundle:AssociadoDependentes')->findOneBy(array('associado' => $associado->getId(), 'dependentes' => $entity->getDependente()->getId()));
                if (!$pertence) {
                    throw $this->createNotFoundException('Este Beneficiario não se encontra na sua lista de Dependentes');
                }
            }

            // pessoa
            $temp_anexo = $entity->getAnexo();
            $entity->setAnexo(null);

            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();

            // uploads
            if ($temp_anexo) {
                $file_name = md5($entity->getId());
                $answer = UploadGeneral::upload($temp_anexo, VarsGeneral::CONS_UPLOAD_SUBSIDIO_ANEXO, $file_name, false);
                $entity->setAnexo($answer);
            }

            $em->flush();   // update 
            //Auditoria
            AuditoriaGeneral::auditar($this, $em, $entity, "Comparticipacao", "I", "Registo de Uma Nova Comparticipação");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('myComparticipacao_AS', array('id' => $associadoCR, 'play' => '20')));
        }

        return $this->render('UsokoSIGBundle:Comparticipacao:PA_NovoCom.html.twig', array(
                    'entity' => $associado,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Comparticipacao entity.
     *
     * @param Comparticipacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Comparticipacao $entity, $associado) {

        $form = $this->createForm(new ComparticipacaoType(), $entity, array(
            'action' => $this->generateUrl('comparticipacao_create', array('associado' => $associado)),
            'method' => 'POST',
            'associado' => $associado,
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));

        return $form;
    }

    /**
     * Displays a form to create a new Comparticipacao entity.
     *
     */
    public function newAction($id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        //$entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('id' => $id, 'tipo' => VarsGeneral::CONS_ASSOCIADO_TIPO_BENETITULAR));

        if (!$entity) {
            throw $this->createNotFoundException('Beneficiario Não Encontrado...');
        }

        $comparticipacao = new Comparticipacao();
        $form = $this->createCreateForm($comparticipacao, $id);

        return $this->render('UsokoSIGBundle:Comparticipacao:PA_NovoCom.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    public function new2Action($id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('id' => $id, 'tipo' => VarsGeneral::CONS_ASSOCIADO_TIPO_BENETITULAR));

        if (!$entity) {
            throw $this->createNotFoundException('Beneficiario Não Encontrado...');
        }

        $comparticipacao = new Comparticipacao();
        $form = $this->createCreateForm($comparticipacao, $id);

        return $this->render('UsokoSIGBundle:Comparticipacao:Atendente/PA_NovoCom.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Comparticipacao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Comparticipacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Comparticipacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Comparticipacao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Comparticipacao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Comparticipacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Comparticipacao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Comparticipacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Comparticipacao entity.
     *
     * @param Comparticipacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Comparticipacao $entity) {
        $form = $this->createForm(new ComparticipacaoType(), $entity, array(
            'action' => $this->generateUrl('comparticipacao_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing Comparticipacao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $valor = $this->valor($request);
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();

        $entity = $em->getRepository('UsokoSIGBundle:Comparticipacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Comparticipacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $entity->setValor((double) $valor);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Comparticipação", "U", "Actualização de Uma Comparticipação");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('comparticipacao_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Comparticipacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Comparticipacao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Comparticipacao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Comparticipacao entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "Comparticipação", "D", "Remoção de Uma Comparticipação");

            $em->remove($entity);
            $em->flush();
            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('comparticipacao'));
    }

    /**
     * Creates a form to delete a Comparticipacao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('comparticipacao_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

    /**
     * @author Kissema Eduardo Rafael <kissol_cfti@hotmail.com>
     */
    public function estatisticaAction() {
        $estatistica = array();
        $em = $this->getDoctrine()->getManager();
        $entities = $em->getRepository('UsokoSIGBundle:Comparticipacao')->findAll();

        $t_pendente = 0;
        $t_aprovada = 0;
        $t_recusada = 0;

        $entity = new Comparticipacao();
        foreach ($entities as $entity) {
            if ($entity->getEstado() == 'P') {
                $t_pendente++;
            } elseif ($entity->getEstado() == 'A') {
                $t_aprovada++;
            } elseif ($entity->getEstado() == 'R') {
                $t_recusada++;
            }
        }


        $estatistica['t_pendente'] = $t_pendente;
        $estatistica['t_aprovada'] = $t_aprovada;
        $estatistica['t_recusada'] = $t_recusada;

        print_r(json_encode($estatistica));
        die;
    }

    public function myComparticipacaoAction($id) {

        $id = \Usoko\SIGBundle\General\CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();
        //$entity = $em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('id' => $id, 'tipo' => VarsGeneral::CONS_ASSOCIADO_TIPO_BENETITULAR));
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);
        if (!$entity) {
            throw $this->createNotFoundException('Associado Não Encontrado .');
        }

        $entities = $em->getRepository('UsokoSIGBundle:Comparticipacao')->findByAssociado($id);

        return $this->render('UsokoSIGBundle:Comparticipacao:PA_ListaCom.html.twig', array(
                    'entity' => $entity,
                    'entities' => $entities,
        ));
    }

    public function myComparticipacaoAtAction($id) {

        $id = \Usoko\SIGBundle\General\CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();
        //$entity = $em->getRepository('UsokoSIGBundle:Associado')->findOneBy(array('id' => $id, 'tipo' => VarsGeneral::CONS_ASSOCIADO_TIPO_BENETITULAR));
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);
        if (!$entity) {
            throw $this->createNotFoundException('Associado Não Encontrado .');
        }

        $entities = $em->getRepository('UsokoSIGBundle:Comparticipacao')->findByAssociado($id);

        return $this->render('UsokoSIGBundle:Comparticipacao:Atendente/PA_ListaCom.html.twig', array(
                    'entity' => $entity,
                    'entities' => $entities,
        ));
    }

    /**
     * Finds and displays a Comparticipacao entity.
     *
     */
    public function showMyAction($id, $solicitacao) {

        $solicitacaoCR = $solicitacao;
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $solicitacao = $this->get('nzo_url_encryptor')->decrypt($solicitacao);

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity.');
        }

        $solicitacao = $em->getRepository('UsokoSIGBundle:Comparticipacao')->find($solicitacao);

        if (!$solicitacao) {
            throw $this->createNotFoundException('Unable to find Solicitação entity.');
        }

        //$solicitacao = new Comparticipacao();
        $espera = DataGeneral::diference($solicitacao->getDataActual());

        $comResEntity = new \Usoko\SIGBundle\Entity\ComparticipacaoResposta();
        $cR = new ComparticipacaoRespostaController();

        $formResposta = $cR->createCreateForm($comResEntity, $solicitacaoCR, $this);
        $formRespostaB = $cR->createCreateFormB($comResEntity, $solicitacaoCR, $this);

        return $this->render('UsokoSIGBundle:Comparticipacao:PA_DadosCom.html.twig', array(
                    'entity' => $entity,
                    'solicitacao' => $solicitacao,
                    'formResposta' => $formResposta->createView(),
                    'formRespostaB' => $formRespostaB->createView(),
                    'espera' => $espera
        ));
    }

    public function codigoGerador() {

        $mes = $this->mesSigla(DataGeneral::tempoParam("m"));
        $ano = DataGeneral::tempoParam("y");

        $data = 'S' . $mes . $ano;
        $repository = $this->getDoctrine()->getRepository('UsokoSIGBundle:Comparticipacao');

        $query = $repository->createQueryBuilder('c')
                ->where('c.codigo like :cod')
                ->setParameter('cod', "$data%")
                ->getQuery();

        $comparticipacao = $query->getResult();

        $total = count($comparticipacao) + 1;

        $rand = rand(0, 9);
        $rand2 = rand(0, 9);
        return $data . $rand . $total . $rand2;
    }

    public function mesSigla($cod) {

        $cod--;
        $sigla = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L'];
        return $sigla[$cod];
    }

    public function consultarCodComparticipacaoAction($chave) {

        $em = $this->getDoctrine()->getManager();
        $chave = base64_decode($chave);
        $entity = $em->getRepository('UsokoSIGBundle:Comparticipacao')->findOneBy(array('codigo' => $chave));
        if (!$entity) {
            $json = json_encode(array("codigo" => 400, "resposta" => null));
        } else {
            $json = json_encode(array("codigo" => 200, "resposta" => $this->get('nzo_url_encryptor')->encrypt($entity->getId())));
        }

        $resposta = new Response($json);
        $resposta->headers->set('Content-Type', 'application/json');
        return $resposta;
    }

    public function showEstaAction($ids, $solicitacao) {

        $solicitacaoCR = $solicitacao;
        $ids = $this->get('nzo_url_encryptor')->decrypt($ids);
        $solicitacao = $this->get('nzo_url_encryptor')->decrypt($solicitacao);

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($ids);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity.');
        }

        $solicitacao = $em->getRepository('UsokoSIGBundle:Comparticipacao')->find($solicitacao);

        if (!$solicitacao) {
            throw $this->createNotFoundException('Unable to find Solicitação entity.');
        }

        //$solicitacao = new Comparticipacao();
        $espera = DataGeneral::diference($solicitacao->getDataActual());

        $comResEntity = new \Usoko\SIGBundle\Entity\ComparticipacaoResposta();
        $cR = new ComparticipacaoRespostaController();

        $formResposta = $cR->createCreateForm($comResEntity, $solicitacaoCR, $this);
        $formRespostaB = $cR->createCreateFormB($comResEntity, $solicitacaoCR, $this);

        return $this->render('UsokoSIGBundle:Comparticipacao:Atendente/PA_DadosCom.html.twig', array(
                    'entity' => $entity,
                    'solicitacao' => $solicitacao,
                    'formResposta' => $formResposta->createView(),
                    'formRespostaB' => $formRespostaB->createView(),
                    'espera' => $espera
        ));
    }

    private function valor($request) {
        $valor = $request->request->get('usoko_sigbundle_comparticipacao')['valor'];
        $valor = NumeroReal::converter($valor);
        return $valor;
    }

}
