<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Cartao;
use Usoko\SIGBundle\Form\CartaoType;
use Usoko\SIGBundle\General\AuditoriaGeneral;

/**
 * Cartao controller.
 *
 */
class CartaoController extends Controller {

    /**
     * Lists all Cartao entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Cartao')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Cartao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Cartao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Cartao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Cartao", "I", "Registo de Um Novo Cartão");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('cartao_show', array('id' => $entity->getId())));
        }

        return $this->render('UsokoSIGBundle:Cartao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Cartao entity.
     *
     * @param Cartao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Cartao $entity) {
        $form = $this->createForm(new CartaoType(), $entity, array(
            'action' => $this->generateUrl('cartao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new Cartao entity.
     *
     */
    public function newAction() {
        $entity = new Cartao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Cartao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Cartao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Cartao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Cartao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Cartao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Cartao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Cartao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Cartao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Cartao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Cartao entity.
     *
     * @param Cartao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Cartao $entity) {
        $form = $this->createForm(new CartaoType(), $entity, array(
            'action' => $this->generateUrl('cartao_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing Cartao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();
        $entity = $em->getRepository('UsokoSIGBundle:Cartao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Cartao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Cartao", "U", "Actualização de Um Cartão");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('cartao_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Cartao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Cartao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Cartao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Cartao entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "Cartao", "D", "Remoção de Um Cartão");

            $em->remove($entity);
            $em->flush();

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('cartao'));
    }

    /**
     * Creates a form to delete a Cartao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('cartao_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

}
