<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\Entity\AssociadoTipoinfraccao;
use Usoko\SIGBundle\Form\AssociadoTipoinfraccaoType;
use Usoko\SIGBundle\General\AuditoriaGeneral;

/**
 * AssociadoTipoinfraccao controller.
 *
 */
class AssociadoTipoinfraccaoController extends Controller {

    /**
     * Lists all AssociadoTipoinfraccao entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:AssociadoTipoinfraccao')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:AssociadoTipoinfraccao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new AssociadoTipoinfraccao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new AssociadoTipoinfraccao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);


        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $utilizador = $this->get('security.context')->getToken()->getUser();
            $entity->setUtilizador($utilizador);
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "AssociadoTipoInfracao", "I", "Registo de Um Novo Tipo de Infração");
            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('associadotipoinfraccao'));
        }

        return $this->render('UsokoSIGBundle:AssociadoTipoinfraccao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a AssociadoTipoinfraccao entity.
     *
     * @param AssociadoTipoinfraccao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(AssociadoTipoinfraccao $entity) {
        $form = $this->createForm(new AssociadoTipoinfraccaoType(), $entity, array(
            'action' => $this->generateUrl('associadotipoinfraccao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));

        return $form;
    }

    /**
     * Displays a form to create a new AssociadoTipoinfraccao entity.
     *
     */
    public function newAction() {
        $entity = new AssociadoTipoinfraccao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:AssociadoTipoinfraccao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a AssociadoTipoinfraccao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:AssociadoTipoinfraccao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find AssociadoTipoinfraccao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:AssociadoTipoinfraccao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing AssociadoTipoinfraccao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:AssociadoTipoinfraccao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find AssociadoTipoinfraccao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:AssociadoTipoinfraccao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a AssociadoTipoinfraccao entity.
     *
     * @param AssociadoTipoinfraccao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(AssociadoTipoinfraccao $entity) {
        $form = $this->createForm(new AssociadoTipoinfraccaoType(), $entity, array(
            'action' => $this->generateUrl('associadotipoinfraccao_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing AssociadoTipoinfraccao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $em->getConnection();

        $entity = $em->getRepository('UsokoSIGBundle:AssociadoTipoinfraccao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find AssociadoTipoinfraccao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "AssociadoTipoInfracao", "U", "Actualização de Um Tipo de Infração");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('associadotipoinfraccao_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:AssociadoTipoinfraccao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a AssociadoTipoinfraccao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:AssociadoTipoinfraccao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find AssociadoTipoinfraccao entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "AssociadoTipoInfracao", "D", "Remoção de Um Associado Tipo de Infração");

            $em->remove($entity);
            $em->flush();

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('associadotipoinfraccao'));
    }

    /**
     * Creates a form to delete a AssociadoTipoinfraccao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('associadotipoinfraccao_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

}
