<?php

namespace Usoko\SIGBundle\Entity;

use Symfony\Component\Security\Core\User\UserInterface;
use Doctrine\ORM\Mapping as ORM;

/**
 * Utilizador
 *
 * @ORM\Table(name="utilizador", uniqueConstraints={@ORM\UniqueConstraint(name="username_UNIQUE", columns={"username"})}, indexes={@ORM\Index(name="fk_Utilizador_Pessoa1_idx", columns={"Pessoa"})})
 * @ORM\Entity(repositoryClass="Usoko\SIGBundle\Repository\UtilizadorRepository")
 */
class Utilizador implements UserInterface, \Serializable {

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="username", type="string", length=100, nullable=false)
     */
    private $username;

    /**
     * @var string
     *
     * @ORM\Column(name="password", type="string", length=45, nullable=false)
     */
    private $password;

    /**
     * @var boolean
     *
     * @ORM\Column(name="isActive", type="boolean", nullable=false)
     */
    private $isactive;

    /**
     * @var \Pessoa
     *
     * @ORM\ManyToOne(targetEntity="Pessoa")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Pessoa", referencedColumnName="id")
     * })
     */
    private $pessoa;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Funcao", inversedBy="utilizador")
     * @ORM\JoinTable(name="utilizador_funcao",
     *   joinColumns={
     *     @ORM\JoinColumn(name="Utilizador", referencedColumnName="id")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="Funcao", referencedColumnName="id")
     *   }
     * )
     */
    private $funcao;

    /**
     * Constructor
     */
    public function __construct() {
        $this->isActive = true;
        $this->funcao = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId() {
        return $this->id;
    }

    /**
     * Set username
     *
     * @param string $username
     * @return Utilizador
     */
    public function setUsername($username) {
        $this->username = $username;

        return $this;
    }

    /**
     * Get username
     *
     * @return string 
     */
    public function getUsername() {
        return $this->username;
    }

    /**
     * Set password
     *
     * @param string $password
     * @return Utilizador
     */
    public function setPassword($password) {
        $this->password = $password;

        return $this;
    }

    /**
     * Get password
     *
     * @return string 
     */
    public function getPassword() {
        return $this->password;
    }

    /**
     * Set isactive
     *
     * @param boolean $isactive
     * @return Utilizador
     */
    public function setIsactive($isactive) {
        $this->isactive = $isactive;

        return $this;
    }

    /**
     * Get isactive
     *
     * @return boolean 
     */
    public function getIsactive() {
        return $this->isactive;
    }

    /**
     * Set pessoa
     *
     * @param \Usoko\SIGBundle\Entity\Pessoa $pessoa
     * @return Utilizador
     */
    public function setPessoa(\Usoko\SIGBundle\Entity\Pessoa $pessoa = null) {
        $this->pessoa = $pessoa;

        return $this;
    }

    /**
     * Get pessoa
     *
     * @return \Usoko\SIGBundle\Entity\Pessoa 
     */
    public function getPessoa() {
        return $this->pessoa;
    }

    /**
     * Add funcao
     *
     * @param \Usoko\SIGBundle\Entity\Funcao $funcao
     * @return Utilizador
     */
    public function addFuncao(\Usoko\SIGBundle\Entity\Funcao $funcao) {
        $this->funcao[] = $funcao;

        return $this;
    }

    /**
     * Remove funcao
     *
     * @param \Usoko\SIGBundle\Entity\Funcao $funcao
     */
    public function removeFuncao(\Usoko\SIGBundle\Entity\Funcao $funcao) {
        $this->funcao->removeElement($funcao);
    }

    /**
     * Get funcao
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getFuncao() {
        return $this->funcao;
    }

    public function serialize() {
        return serialize(array(
            $this->id,
            $this->username,
            $this->password));
    }

    public function unserialize($serialized) {
        list (
                $this->id,
                $this->username,
                $this->password,
                ) = unserialize($serialized);
    }

    public function eraseCredentials() {
        
    }

    public function getRoles() {
        //return $this->funcao->toArray()
        return array('ROLE_ADMIN');
    }

    public function getSalt() {
        return null;
    }

}
