<?php $__env->startSection('title', 'Categoria de Parceiros'); ?>

<?php $__env->startSection('subtitle','Listagem'); ?>

<?php $__env->startSection('conteudo'); ?>
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="<?php echo e(route('admin')); ?>">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Configurações</span></li>
                    <li><span>Categoria de Parceiros</span></li>
                    <li><span>Listagem</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        
        <?php if(session('success')): ?>
            <script>
                Swal.fire({
                    title: 'Sucesso',
                    icon:'success',
                    text: '<?php echo e(session('success')); ?>',
                    confirmButtonText: 'Fechar'
                })
            </script>
        <?php endif; ?>

        <!-- start: page -->
        <div class="row" style="padding-top: 80px;">
            <div class="col">
                <section class="card">
                    <header class="card-header">
                        <div class="card-actions">
                            
                        </div>
                        <h2 class="card-title">Listagem de Categoria de Parceiros</h2>
                    </header>
                    <div class="card-body">
                        
                        <table class="table table-bordered table-striped mb-0" id="datatable-tabletools">
                            <thead>
                                <a id="addToTable" href="<?php echo e(route('categoria-de-parceiro.create')); ?>" class="btn btn-dark">Adicionar Nova Categoria <i class="fas fa-plus"></i></a>
                                <tr>
                                    <th>#</th>
                                    <th>Nome </th>
                                    <th>Estado</th>
                                    <th>Acção</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td> <?php echo e($loop->index + 1); ?></td>
                                        <td><?php echo e($categoria->nome ?? ''); ?></td>
                                        <?php if($categoria->estado): ?>
                                            <td><span class="badge badge-success">Activo</span></td>
                                        <?php else: ?>
                                            <td><span class="badge badge-warning">Inativo</span></td>
                                        <?php endif; ?>
                                        <td class="actions">
                                            <a href="<?php echo e(route('categoria-de-parceiro.show', encrypt($categoria->id))); ?>"><i class="fa-solid fa-eye"></i></a>
                                            <a href="<?php echo e(route('categoria-de-parceiro.edit', encrypt($categoria->id))); ?>"><i class="fas fa-pencil-alt"></i></a>
                                            <?php if(!Gate::allows('isEditor')): ?>
                                                <a class="mb-1 mt-1 me-1 modal-basic" href="#modalEliminar<?php echo e($categoria->id); ?>"><i class="far fa-trash-alt"></i></a>
                                            <?php endif; ?>
                                        </td>


                                        <div id="modalEliminar<?php echo e($categoria->id); ?>" class="modal-block modal-block-danger mfp-hide">
                                            <section class="card">
                                                <header class="card-header">
                                                    <h2 class="card-title">AVISO!</h2>
                                                </header>
                                                <div class="card-body">
                                                    <div class="modal-wrapper">
                                                        <div class="modal-icon">
                                                            <i class="fas fa-times-circle"></i>
                                                        </div>
                                                        <div class="modal-text">
                                                            <h4 class="font-weight-bold text-dark">AVISO</h4>
                                                            <p>Deseja realmente eliminar esta Categoria de Parceiro?</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <form action="<?php echo e(route('categoria-de-parceiro.destroy', encrypt($categoria->id))); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <footer class="card-footer">
                                                        <div class="row">
                                                            <div class="col-md-12 text-end">
                                                                <button class="btn btn-primary modal-dismiss">Cancelar </button>
                                                                <button type="submit" class="btn btn-danger">Sim, Elimine-o</button>
                                                            </div>
                                                        </div>
                                                    </footer>
                                                </form>
                                            </section>
                                        </div>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>

        <!-- end: page -->
    </section>
<?php $__env->stopSection(); ?>

    

<?php $__env->startSection('javascript'); ?>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.platform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\OlimpoPortal\resources\views/admin/configuracoes/categoriaParceiros/index.blade.php ENDPATH**/ ?>