<?php $__env->startSection('title', 'Entidade Visual'); ?>

<?php $__env->startSection('subtitle','Registro'); ?>

<?php $__env->startSection('conteudo'); ?>
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="<?php echo e(route('admin')); ?>">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Configurações</span></li>
                    <li><span>Entidade</span></li>
                    <li><span>Visual</span></li>
                    <li><span>Registro</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        <?php if($errors->any()): ?>
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        <?php endif; ?>

        <div class="row" style="padding-top: 80px;">
            <form action="<?php echo e(route('entidade-visual.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                
                            </div>
                            <h2 class="card-title">Registro de uma Entidade Visual</h2>
                            
                        </header>

                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-4 text-center d-flex justify-content-center">
                                    <div class="row">
                                        <span>Visual <span style="color: red;">*</span></span>
                                        <label for="imageUpload" class="cursor-pointer" title="Clique para escolher a imagem">
                                            <div class="position-relative">
                                                <!-- Preview da imagem -->
                                                <img id="imagePreview" src="<?php echo e(asset('admin/img/logo.png')); ?>" 
                                                    class=" border border-3 m-1" 
                                                
                                                    style="width: 300px; height: 200px; object-fit: fill;" 
                                                    alt="imagem ">
                                            </div>
                                        <!-- Botão de seleção -->
                                        </label>
                                        <input type="file" id="imageUpload" accept="image/jpeg,image/jpg,image/png"  name="logo" required
                                            class="form-control d-none" onchange="previewImage(event)">
                                    </div>
                                </div>

                                <!-- Coluna dos Inputs -->
                                <div class="col-lg-8">
                                    <span id="nota" style="background-color: #ffeb3b; color: #333; font-weight: bold; padding: 5px 10px; border-left: 4px solid #f44336; display: inline-block; border-radius: 3px; font-size: 1.1em; margin: 10px 0;"></span>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <label for="titulo" class="form-label">Nome da Entidade <span id="nomeColor" style="color: red;"></span></label>
                                                <input type="text" class="form-control" id="nome" maxlength="100" name="nome" placeholder="Digite o nome" >
                                                <small id="counterTitulo" class="form-text text-muted mt-1">0 / 100 caracteres</small>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <label for="logo" class="form-label">Localização <span style="color: red;">*</span></label>
                                            <select class="form-select" onchange="taggleLocation(this.value)" id="local" name="local" required>
                                                <option value="" disabled selected>Selecione...</option>
                                                <option value="1">Email (Header)</option>
                                                <option value="2">Email (Rodapé)</option>
                                                
                                                <option value="4">Portal (Header)</option>
                                                <option value="5">Portal (Rodapé)</option>
                                                
                                                <option value="7">Portal (Marca de água)</option>
                                                <option value="8">Portal (Boas vindas - header)</option>
                                                <option value="9">Portal (Boas vindas - rodapé)</option>
                                                <option value="10">Sistema (Background)</option>
                                                <option value="11">Area Reservada (Dashboard)</option>
                                                <option value="12">Area Reservada (Fluxo de autenticação)</option>                                            
                                                <option value="13">Todos</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <label for="estado" class="form-label">Estado <span style="color: red;">*</span></label>
                                            <select class="form-select" id="estado" name="estado" required>
                                                <option value="" disabled selected>Selecione o estado</option>
                                                <option value="1">Activo</option>
                                                <option value="0">Inativo</option>
                                            </select>
                                        </div>
                                    </div>
                                    <p>Apenas os campos marcados com <span style="color: red;">*</span> são
                                        obrigatórios.</p>
                                </div>                            
                            </div>
                        </div>

                        <footer class="card-footer text-end">
                            <a href="<?php echo e(route('entidade-visual.index')); ?>" class="btn btn-dark">Voltar</a>
                            <button class="btn btn-warning">Submeter</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>

        <!-- end: page -->
    </section>

    <script src="<?php echo e(asset("admin/js/Validacao/entidadeVisual.js")); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.platform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\OlimpoPortal\resources\views/admin/configuracoes/entidade/visual/create.blade.php ENDPATH**/ ?>