<?php $__env->startSection('icone-modulo', 'fa fa-building'); ?>
<?php $__env->startSection('icone', 'fa fa-houzz'); ?>

<?php $__env->startSection('content'); ?>

    <!-- Seção do cabeçalho -->
    <section class="page-header page-header-modern page-header-background page-header-background-md overlay overlay-color-dark overlay-show overlay-op-7"
        style="background-image: url(<?php echo e(optional($bunnerItem)->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunnerItem->imagem) : asset('admin/imgDefault.png')); ?>);">
        <div class="container">
            <div class="row mt-5">
                <div class="col-md-12 align-self-center p-static order-2 text-center">
                    <h1 class="text-12 font-weight-semibold">Conheça a Nossa Estrutura</h1>
                </div>
                <div class="col-md-12 align-self-center order-1">
                    <ul class="breadcrumb breadcrumb-light d-block text-center">
                        <li><a href="#">Página Principal</a></li>
                        <li class="active">Sobre</li>
                        <li class="active">Estrutura Orgânica</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- Seção de descrição -->
    <section class="section section-default border-0 my-5">
        <div class="container py-4">
            <h2 class="text-color-dark font-weight-bold text-8 mb-4 text-center mb-0 pt-2">
                <?php echo e($estrutura->titulo ?? ''); ?></h2>
            <p class="card-text mt-2 pb-1 text-center"><?php echo e($estrutura->descricao ?? ''); ?></p>
        </div>
    </section>

    <!-- Loop dos membros -->
    <?php $__currentLoopData = $membros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $membro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="container py-4">
            <div class="row align-items-stretch">
                <div class="col-md-6 order-2 d-flex flex-column justify-content-center">
                    <div class="overflow-hidden">
                        <h2 class="text-color-dark font-weight-bold text-8 mb-0 pt-0 mt-0 appear-animation"
                            data-appear-animation="maskUp" data-appear-animation-delay="300">
                            <?php echo e($membro->nome ?? ''); ?>

                        </h2>
                    </div>
                    <div class="toggle toggle-primary toggle-simple" data-plugin-toggle>
                        <section  <?php if($membro->cargos->principal == 1): ?> class="toggle active" <?php else: ?> class="toggle" <?php endif; ?>>
                            <a class="toggle-title" style="text-decoration: none">
                                <div class="overflow-hidden mb-3">
                                    <p style="color: <?php echo e($config->secondary_color ?? 'black'); ?>" class="font-weight-bold text-uppercase mb-0 appear-animation"
                                        data-appear-animation="maskUp" data-appear-animation-delay="500">
                                        <?php echo e($membro->cargos->nome ?? ''); ?>

                                    </p>
                                </div>
                            </a>
                            <div class="toggle-content">
                                <p class="pb-3 appear-animation" style="text-align: justify"
                                    data-appear-animation="fadeInUpShorter" data-appear-animation-delay="700">
                                    <?php echo nl2br(e($membro->biografia ?? '')); ?>

                                </p>
                            </div>
                        </section>
                    </div>
                </div>
                <div class="col-md-6 order-md-2 mb-4 mb-lg-0 d-flex align-items-center appear-animation" 
                    data-appear-animation="fadeInRightShorter">
                    <img 
                        src="<?php echo e($membro ? asset('admin/imagens/membrosComissao/'.$membro->foto) : ''); ?>" 
                        class="img-fluid rounded shadow-lg" 
                        style="height: 60%; object-fit: cover;" 
                        alt="<?php echo e($membro->nome); ?>">
                </div>
            </div>
            
            <hr class="solid my-4 appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="900">
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <!-- Seção de organograma -->
    <section class="section section-default border-0 my-5">
        <div class="container py-4">
            <div class="row">
                <div class="col pb-4 text-center">
                    <h2 class="text-color-dark font-weight-normal text-7 mb-0 pt-2">
                        <strong class="font-weight-extra-bold">Organigrama</strong>
                    </h2>
                    <img 
                        src="<?php echo e($estrutura ? asset('admin/imagens/estruturaOrganica/'.$estrutura->img_organigrama) : ''); ?>"
                         class="img-fluid border-radius-0" 
                         alt="Organigrama">
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <!-- Scripts personalizados, se necessários -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\OlimpoPortal\resources\views/olimpoPortal/estruturaOrganica.blade.php ENDPATH**/ ?>