<?php $__env->startSection('icone-modulo',"fa fa-building"); ?>

<?php $__env->startSection('icone','fa fa-houzz'); ?>



<?php $__env->startSection('content'); ?>

            <section class="page-header page-header-modern page-header-background page-header-background-md overlay overlay-color-dark overlay-show overlay-op-7" style="background-image: url(<?php echo e(optional($bunnerItem)->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunnerItem->imagem) : asset('admin/imgDefault.png')); ?>);">
                <div class="container">
                    <div class="row mt-5">
                        <div class="col-md-12 align-self-center p-static order-2 text-center">
                            <h1 class="text-12 font-weight-semibold">Notícia</h1>
                        </div>
                        <div class="col-md-12 align-self-center order-1">
                            <ul class="breadcrumb breadcrumb-light d-block text-center">
                                <li><a href="<?php echo e(route('home')); ?>">Pagina principal</a></li>
                                <li class="active">Notícia</li>
                                <li class="active">Detalhe</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>
            

            <div class="container mt-4">
                <div class="row">
                    <!-- Coluna principal: Notícia selecionada -->
                    <div class="col-lg-8" id="noticia-detalhes-container" >
                        <!-- Título da Notícia -->
                        <h2 class="word-rotator slide font-weight-bold text-7 mb-2">
                            <span><?php echo e(strtoupper($noticia->titulo)); ?></span>
                        </h2>

                        <!-- Data de Publicação -->
                        <p class="slide text-4 mb-4">Data da Publicação: <?php echo e($noticia->data_publicacao); ?></p>

                        <!-- Destaque -->
                        <?php if($noticia->destaque == 1): ?>
                            <p class="btn btn-dark">Notícia em Destaque</p>
                        <?php endif; ?>

                        <!-- Mídia da Notícia -->
                        <?php if($noticia->midias && count($noticia->midias) > 0): ?>
                            <div id="carouselMidiasEvento" class="carousel slide mb-4" data-bs-ride="carousel">
                                <div class="carousel-inner">
                                    <?php $__currentLoopData = $noticia->midias->filter(fn($m) => $m->estado == 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="carousel-item <?php echo e($index === 0 ? 'active' : ''); ?>" style="width: 100%; height: 450px;">
                                            <?php if(Str::endsWith($media->ficheiro, ['.mp4', '.webm'])): ?>
                                                <video autoplay muted loop controls class="w-100" style="height: 100%; height: 450px; object-fit: cover;" preload="metadata">
                                                    <source src="<?php echo e(asset('admin/imagens/noticias/midia/' . $media->ficheiro)); ?>" type="video/mp4">
                                                    Seu navegador não suporta vídeo.
                                                </video>
                                            <?php elseif($media->link_video): ?>
                                                <iframe 
                                                    src="<?php echo e($media->link_video); ?>"
                                                    style="width: 100%; height: 100%; object-fit: cover;"
                                                    title="Vídeo do evento"
                                                    frameborder="0"
                                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                                    allowfullscreen>
                                                </iframe>
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('admin/imagens/noticias/midia/' . $media->ficheiro)); ?>"
                                                    class="img-fluid rounded shadow"
                                                    style="width: 100%; height: 100%; object-fit: cover;"
                                                    alt="Imagem do evento">
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <!-- Controles do Carrossel -->
                                <a class="carousel-control-prev" href="#carouselMidiasEvento" role="button" data-bs-slide="prev">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                </a>
                                <a class="carousel-control-next" href="#carouselMidiasEvento" role="button" data-bs-slide="next">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                </a>
                            </div>
                        <?php else: ?>
                            <!-- Imagem padrão da notícia -->
                            <div class="post-image mb-3 mt-3">
                                <img src="<?php echo e(asset('admin/imagens/noticias/' . $noticia->imagem)); ?>"
                                    class="img-fluid rounded shadow"
                                    style="width: 100%; height: 450px; object-fit: cover;"
                                    alt="Imagem do evento">
                            </div>
                        <?php endif; ?>

                        <!-- Conteúdo da Notícia -->
                        <article class="post post-large pb-5">
                            <!-- Data Formatada -->
                            <div class="post-date mb-2">
                                <span style="color: <?php echo e($config->secondary_color ?? 'black'); ?>" class="day d-block">
                                    <?php echo e(date('d', strtotime($noticia->data_publicacao))); ?>

                                </span>
                                <span style="background-color: <?php echo e($config->secondary_color ?? 'black'); ?>" class="month d-block">
                                    <?php echo e(date('M', strtotime($noticia->data_publicacao))); ?>

                                </span>
                            </div>

                            <!-- Corpo -->
                            <div class="post-content">
                                <p class="text-muted"><strong>Resumo: </strong><?php echo e($noticia->resumo); ?></p>
                                <p align="justify"><?php echo $noticia->corpo_noticia ?? ''; ?></p>
                            </div>
                        </article>
                    </div>

            
                    <!-- Coluna lateral: Notícias recentes -->
                    <div class="col-lg-4" >
                        <h4 class="font-weight-bold mb-3">Notícias em Destaques</h4>
                            <ul class="list-unstyled" id="noticias-container">
                                <?php if(count($noticiasDestaques) < 1 ): ?>
                                    <span>Sem notícias em destaques</span>
                                <?php else: ?>
                                    <?php $__currentLoopData = $noticiasDestaques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $noticiaRecente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-lg-12 mb-4">
                                            <article class="post post-large pb-5">
                                                <div class="post-image text-center">
                                                    <a href="<?php echo e(route('noticias.detalhe', encrypt($noticiaRecente->id))); ?>">
                                                        <img src="<?php echo e(asset('admin/imagens/noticias/' . $noticiaRecente->imagem)); ?>" 
                                                            style="width: 500px; height: 200px; object-fit: cover;"
                                                            class="img-fluid img-thumbnail img-thumbnail-no-borders rounded-0" 
                                                            alt="" />
                                                    </a>
                                                </div>
                                        
                                                <div class="post-date text-center">
                                                    <span style="color: <?php echo e($config->secondary_color ?? 'black'); ?>" class="day d-block"><?php echo e(date('d', strtotime($noticiaRecente->data_publicacao))); ?></span>
                                                    <span style="background-color: <?php echo e($config->secondary_color ?? 'black'); ?>" class="month d-block"><?php echo e(date('M', strtotime($noticiaRecente->data_publicacao))); ?></span>
                                                </div>
                                        
                                                <div class="post-content">                                 
                                                    <h4>
                                                        <a href="<?php echo e(route('noticias.detalhe', encrypt($noticiaRecente->id))); ?>" 
                                                         style="color: <?php echo e($config->secondary_color ?? 'black'); ?>">
                                                        <?php echo e($noticiaRecente->titulo ?? ''); ?>

                                                        </a>
                                                    </h4>
                                                    <p class="mb-1 text-justify">
                                                        <?php echo e($noticiaRecente->resumo ?? ''); ?>

                                                    </p>
                                                    <a href="<?php echo e(route('noticias.detalhe', encrypt($noticiaRecente->id))); ?>" 
                                                    class="read-more text-color-dark font-weight-bold text-2">
                                                    Ver mais <i class="fas fa-chevron-right text-1 ms-1"></i>
                                                    </a>
                                                </div>
                                            </article>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </ul>
                        </h4>
                    </div>
                </div>
            </div>

            

        </div>








        </div>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('javascript'); ?>
<script>
    const container = document.getElementById('noticias-container');

    dados.noticias.forEach(noticia => {
        const noticiaHTML = `
                <li class="mb-4 ">
                    <p class="text-muted" align="justify">Sem notícias recentes</p>
                </li>
        `;
        container.innerHTML += noticiaHTML;
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\OlimpoPortal\resources\views/olimpoPortal/detalhe_noticia.blade.php ENDPATH**/ ?>