<?php

use App\Http\Controllers\AppConfigController;
use App\Http\Controllers\AssociadoController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\CandidatoController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ContactoController;
use App\Http\Controllers\SimuladorController;
use App\Http\Controllers\SecurityController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\NoticiaController;
use App\Http\Controllers\BeneficioController;
use App\Http\Controllers\ParceiroController;
use App\Http\Controllers\CategoriaParceiroController;
use App\Http\Controllers\CategoriaBeneficioController;
use App\Http\Controllers\ValoresController;
use App\Http\Controllers\PerguntaFrequenteController;
use App\Http\Controllers\LegislacaoController;
use App\Http\Controllers\ContactoAdminController;
use App\Http\Controllers\AuditoriaGeralController;
use App\Http\Controllers\BunnerController;
use App\Http\Controllers\CargoController;
use App\Http\Controllers\CarrosselController;
use App\Http\Controllers\EmailLogController;
use App\Http\Controllers\EntidadeSysController;
use App\Http\Controllers\EstruturaOrganicaController;
use App\Http\Controllers\EventoController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\MembroComissaoController;
use App\Http\Controllers\MidiaEventoController;
use App\Http\Controllers\MidiaNoticiaController;
use App\Http\Controllers\MissaoVisaoController;
use App\Http\Controllers\NotificacaoConfigController;
use App\Http\Controllers\PainelController;
use App\Http\Controllers\PCAMensagemController;
use App\Http\Controllers\PRMensagemController;
use App\Http\Controllers\SobreController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
//Controlo de Acesso ----------------------------------------------------
Route::get('/login', [SecurityController::class, 'login'])->name('login');
Route::post('/authLogin', [SecurityController::class, 'authLogin'])->name('auth.login');
Route::get('/logout', [SecurityController::class, 'authLogout'])->name('auth.logout');

Route::get('/authReset', [SecurityController::class, 'enviarLink'])->name('auth.reset');
Route::post('/authReset/store', [SecurityController::class, 'enviarLinkStore'])->name('auth.reset.store');

Route::get('/authReset/confirmar-codigo/{username}', [SecurityController::class, 'confirmarCodigo'])->name('auth.reset.confirmarCodigo');
Route::post('/authReset/confirmar-codigo/store', [SecurityController::class, 'confirmarCodigoStore'])->name('auth.reset.confirmarCodigo.store');

Route::get('/authReset/alterar-palavra-passe/{username}', [SecurityController::class, 'resetPalavraPasse'])->name('auth.reset.resetars');
Route::post('/authReset/alterar-palavra-passe/store', [SecurityController::class, 'resetPalavraPasseStore'])->name('auth.reset.resetars.store');


Route::get('/authReset/reeviar-codigo/{email}', [SecurityController::class, 'reeviarCodigo'])->name('reenviar.codigo');


//Dashboard principal ----------------------------------------------------
Route::get('/Pagina-Inicial-Admin', [HomeController::class, 'homeAdmin'])->middleware('auth')->name('homeAdmin');
Route::get('/Pagina-Inicial-Editor', [HomeController::class, 'homeEditor'])->middleware('auth')->name('homeEditor');
Route::get('/Pagina-Inicial-Gestor', [HomeController::class, 'homeGestor'])->middleware('auth')->name('homeGestor');



Route::get('/', [SiteController::class, 'home'])->name('home');
Route::get('apresentacao', [SiteController::class, 'apresentacao'])->name('apresentacao');
Route::get('estruturaOrganica', [SiteController::class, 'estruturaOrganica'])->name('estruturaOrganica');
Route::get('mensagemPresidente', [SiteController::class, 'mensagemPresidente'])->name('mensagemPresidente');
Route::get('mensagemPca', [SiteController::class, 'mensagemPCA'])->name('mensagemPca');
Route::get('contactos', [SiteController::class, 'contactos'])->name('contactos');
Route::get('perguntasFrequentes', [SiteController::class, 'perguntasFrequentes'])->name('perguntasFrequentes');
Route::get('missaoValor', [SiteController::class, 'missaoValor'])->name('missaoValor');

Route::get('relatorios', [SiteController::class, 'relatorios'])->name('relatorios');
Route::get('empresasParceiras', [SiteController::class, 'empresasParceiras'])->name('empresasParceiras');
Route::get('beneficios', [SiteController::class, 'beneficios'])->name('beneficios');
Route::get('calendarioEventos', [SiteController::class, 'calendarioEventos'])->name('calendarioEventos');
Route::get('legislacao', [SiteController::class, 'legislacao'])->name('legislacao');
Route::get('noticias', [SiteController::class, 'noticias'])->name('noticias');
Route::get('noticias/detalhe/{id}', [SiteController::class, 'noticiasDetalhe'])->name('noticias.detalhe');
Route::get('eventos-actividades', [SiteController::class, 'eventos'])->name('eventos');
Route::get('eventos/detalhe/{id}', [SiteController::class, 'eventosDetalhe'])->name('eventos.detalhe');
Route::get('simulador/subsidioreforma', [SimuladorController::class, 'simuladorComplementoReforma'])->name('simular.compl.reforma');

Route::post('/contactos', [ContactoController::class, 'contactoenvio'])->name('contacto.store');

Route::get('serMembro', [CandidatoController::class, 'index'])->name('candidato.create');
Route::get('boas-vindas', [CandidatoController::class, 'boasVindas'])->name('boasvindas');
Route::resource('cadastros', CandidatoController::class);

Route::group(['middleware' => ['auth']], function () {

    Route::get('dashboard', [UserController::class, 'dashboard'])->name('admin');

    Route::post('gestor/associado/new/add', [AssociadoController::class, 'addAssociado']);
    Route::post('gestor/utilizador/new/add', [UserController::class, 'createAccountUser']);


    //Utilizadores ----------------------------------------------------
    Route::resource('utilizadors', UserController::class);

    //Perfis ----------------------------------------------------
    Route::resource('perfis', RoleController::class);
    Route::get('perfil/{id}', [UserController::class, 'verPerfil'])->name('admin.user.perfil');
    Route::post('perfil/alterar-minha-palavra-passe', [SecurityController::class, 'resetMyPalavraPasseStore'])->name('reset.pass.Myperfil.store');
    Route::post('perfil/alterar-palavra-passe', [SecurityController::class, 'resetPalavraPassePerfilStore'])->name('reset.pass.perfil.store');

    //Noticia ----------------------------------------------------
    Route::resource('entidade-visual', EntidadeSysController::class);

    
    //Notificações ----------------------------------------------------
    Route::resource('sys-notificacoes', NotificacaoConfigController::class);

    //APP CONFIG ----------------------------------------------------
    Route::get('app-config', [AppConfigController::class, 'index'])->name('admin.config.appConfig');
    Route::post('app-config/add', [AppConfigController::class, 'store'])->name('admin.config.appConfig.add');

    //Noticia ----------------------------------------------------
    Route::resource('noticia', NoticiaController::class);

    //Midia Noticias ----------------------------------------------------
    Route::resource('midias-noticias', MidiaNoticiaController ::class);

    //Eventos ----------------------------------------------------
    Route::resource('eventos', EventoController::class);

    //Midia Eventos ----------------------------------------------------
    Route::resource('midias-eventos', MidiaEventoController::class);

    //Beneficio ----------------------------------------------------
    Route::resource('beneficio', BeneficioController::class);

    //Parceiros ----------------------------------------------------
    Route::resource('parceiro', ParceiroController::class);

    //Categoria de Parceiros ----------------------------------------------------
    Route::resource('categoria-de-parceiro', CategoriaParceiroController::class);


    //Categoria de Parceiros ----------------------------------------------------
    Route::resource('categoria-de-beneficio', CategoriaBeneficioController::class);

    //Missao e Visao ----------------------------------------------------
    Route::resource('missao-visao', MissaoVisaoController::class);

    //Valores ----------------------------------------------------
    Route::resource('valores', ValoresController::class);

    //Cargo ----------------------------------------------------
    Route::resource('cargo', CargoController::class);

    //rotas para o painel ----------------------------------------------------
    // Route::resource('painel', PainelController::class);
    Route::get('/painel', [PainelController::class, 'index'])->name('painel.index');
    Route::get('painel/update-profissoes', [PainelController::class, 'updateProfissoes'])->name('painel.update.profissoes');
    Route::get('painel/updateTT', [PainelController::class, 'updateOrgaos'])->name('painel.update.orgaos');

    //Perguntas Frequentes ------------------------------------------
    Route::resource('perguntas-frequentes', PerguntaFrequenteController::class);

    //Perguntas Frequentes ------------------------------------------
    Route::resource('membros-comissao', MembroComissaoController::class);

    //Estrutura Organia ------------------------------------------
    Route::resource('estrutura-organica', EstruturaOrganicaController::class);

    //Mensagem do PR ------------------------------------------
    Route::resource('mensagem-presidente', PRMensagemController::class);
    
    //Mensagem do PCA ------------------------------------------
    Route::resource('mensagem-pca', PCAMensagemController::class);

    //Legislação ------------------------------------------
    Route::resource('legislacoes', LegislacaoController::class);

    //Bunner slide (Carrossel Portal) ------------------------------------------
    Route::resource('bunner', BunnerController::class);

     //Carrossel (Boas Vindas) ------------------------------------------
    Route::resource('carrossel', CarrosselController::class);

    //Sobre ----------------------------------------------------
    Route::resource('sobre', SobreController::class);

    //Candidatos ------------------------------------------
    Route::get('candidatos/listagem', [CandidatoController::class, 'index2'])->name('candidato.listar');

    //Contactos ------------------------------------------
    Route::resource('contactos-portal', ContactoAdminController::class);

    //Auditoria Geral
    Route::resource('auditoria-geral', AuditoriaGeralController::class);

    //Logs Email
    Route::resource('logs-email', EmailLogController::class);
    Route::post('/reenviar-email/{id}', [EmailLogController::class, 'reenviar'])->name('reenviar');
    Route::post('/reenviar-todos-emais/nao-enviados', [EmailLogController::class, 'reenviarTodos'])->name('reenviar.emais.naoEnviados');

});
