@extends('layouts.base')

@section('icone-modulo', 'fa fa-building')

@section('icone', 'fa fa-houzz')



@section('content')



    <section
        class="page-header page-header-modern page-header-background page-header-background-md overlay overlay-color-dark overlay-show overlay-op-7"
        style="background-image: url({{ optional($bunnerItem)->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunnerItem->imagem) : asset('admin/imgDefault.png') }});">
        <div class="container">
            <div class="row mt-5">
                <div class="col-md-12 align-self-center p-static order-2 text-center">
                    <h1 class="text-12 font-weight-semibold">Perguntas Frequentes</h1>
                </div>
                <div class="col-md-12 align-self-center order-1">
                    <ul class="breadcrumb breadcrumb-light d-block text-center">
                        <li><a href="{{ route('home') }}">Pagina principal</a></li>
                        <li class="active">Informação</li>
                        <li class="active">FAQ</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>



    </div>
    </div>

    </div>


    <div class="row">
        <div class="container py-4">
            {{-- <h2 class="font-weight-normal text-7 mb-2">Perguntas <strong class="font-weight-extra-bold">Frequentes</strong>
            </h2> --}}
            <p class="lead">Saiba mais sobre o {{$bunnerItem->titulo ?? 'Template N2BS'}} </p>

            <hr class="solid my-5">
            <div class="row g-4">
                @foreach ($perguntas as $pergunta)
                    <div class="col-md-4 col-lg-4 appear-animation mr-lg-6" 
                         data-appear-animation="fadeInUpShorter" 
                         data-appear-animation-delay="600">
                        <div class="card flip-card flip-card-3d text-center rounded-0">
                            <!-- Front of the card -->
                            <div class="flip-front d-flex align-items-center justify-content-center p-4 m-2"  
                                 style="width: 380px; height: 280px; background-color: #f8f9fa;">
                                <div class="flip-content text-center">
                                    {{-- <strong class="font-weight-extra-bold text-color-dark line-height-1 text-13 mb-3 d-inline-block"></strong> --}}
                                    <span style="color: {{ $config->secondary_color ?? 'black' }}" class="font-weight-bold text-5">{{ $pergunta->pergunta ?? '' }}?</span>
                                </div>
                            </div>
                            <!-- Back of the card -->
                            <div class="flip-back d-flex align-items-center justify-content-center p-3 text-center m-2" 
                                 style="background-image: url('{{ asset('frontend/img/generic/generic-corporate-17-1.jpg') }}'); background-size: cover; background-position: center; width: 380px; height: 280px;">
                                <div class="flip-content text-center">
                                    <p class="font-weight-light text-color-light text-4"
                                       style="color: #ffffff; font-size: 14px;">{{ $pergunta->resposta ?? '' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>            
        </div>
    </div>
    <br>
    <div class="row">
        <div class="row">
            <div class="row">
                <div class="row">
                </div>
            </div>
        </div>
        <hr>
    </div>


@endsection


@section('javascript')

@endsection
