@extends('layouts.base')

@section('icone-modulo', 'fa fa-building')

@section('icone', 'fa fa-houzz')



@section('content')

    <section
        class="page-header page-header-modern page-header-background page-header-background-md overlay overlay-color-dark overlay-show overlay-op-7"
        style="background-image: url({{ optional($bunnerItem)->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunnerItem->imagem) : asset('admin/imgDefault.png') }});">
        <div class="container">
            <div class="row mt-5">
                <div class="col-md-12 align-self-center p-static order-2 text-center">
                    <h1 class="text-12 font-weight-semibold">Missão, Visão e Valores</h1>
                </div>
                <div class="col-md-12 align-self-center order-1">
                    <ul class="breadcrumb breadcrumb-light d-block text-center">
                        <li><a href="{{ route('home') }}">Pagina principal</a></li>
                        <li class="active">Sobre</li>
                        <li class="active">Missão, Visão e Valores</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>




    </div>
    </div>

    </div>




    {{-- <section class="section section-height-3 bg-color-grey m-0 border-0">

        <div class="container py-4 my-5">

            <div class="row text-center" style="display: flex; align-items: center; justify-content: center;  ">
                <div class="col-md-4 appear-animation" data-appear-animation="fadeInLeftShorter"
                    data-appear-animation-delay="800">
                    <div class="text-center ">
                        <img src="{{ asset('frontend/img/missao.png') }}" alt="">
                        <h3 class="font-weight-bold text-4 mb-2">Missão</h3>
                    </div>
                    <p class="text-color-dark" align="justify">Promover o bem-estar, a segurança e a valorização dos
                        trabalhadores do sector dos transportes, oferecendo suporte socioeconômico, assistência contínua e
                        benefícios que garantam melhores condições de vida e de trabalho para todos os profissionais
                        envolvidos.</p>
                    <div></div>
                </div>

                <div class="col-md-4 appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="600"
                    >
                    <div class="text-center ">
                        <img src="{{ asset('frontend/img/visao.png') }}" alt="" align="justify">
                        <h3 class="font-weight-bold text-4 mb-2">Visão</h3>
                    </div>
                    <p class="text-color-dark" align="justify">Ser a referência nacional em assistência e apoio ao
                        trabalhador, promovendo a melhoria das condições de trabalho, a equidade social e o desenvolvimento
                        sustentável do sector, sempre com foco na dignidade e na qualidade de vida dos seus profissionais.

                    </p>
                </div>

                {{-- <div class="col-md-4 appear-animation" data-appear-animation="fadeInRightShorter"
                    data-appear-animation-delay="800">
                    <div class="text-center ">
                        <img src="{{ asset('frontend/img/valores.png') }}" alt="">
                        <h3 class="font-weight-bold text-4 mb-2">Valores</h3>
                    </div>
                    <p class="text-color-dark" align="justify"> Honestidade, Compromisso, Transparência , Equidade,
                        Integridade, Lealdade, Respeito e Sigilo.</p>
                </div>
            </div>

        </div>
    </section> --}}

     <!-- ======= Services Section ======= -->
    <section id="services" class="services mb-5">
        <div class="container ">
            <div class="section-title">
                {{-- <span>Valores</span> --}}
                <h2>Missão e Visão</h2>
            </div>

            <div class="row justify-content-center">
                @foreach ($metas as $meta)
                    <div class="col-lg-4 mb-4 mb-lg-0" style="height: 500px;">
                        <div class="featured-boxes featured-boxes-modern-style-2 featured-boxes-modern-style-2-hover-only featured-boxes-modern-style-primary my-4" style="height: 500px;">
                            <div class="featured-box">
                                <div class="box-content px-lg-4 px-xl-5 py-lg-5" style="height: 500px;">
                                    @if ($meta->categoria)
                                        <i style="color: {{ $config->secondary_color ?? 'black' }}" class="icon-featured fa-solid fa-bullseye "></i>
                                    @else
                                        <i style="color: {{ $config->secondary_color ?? 'black' }}" class="icon-featured fa-solid fa-eye "></i>
                                    @endif
                                    <h2 class="font-weight-normal"><strong>{{$meta->categoria ? 'Missão' : 'Visão'}}</strong></h2>
                                    <p class="mb-0" style="text-align: justify;">{{$meta->descricao ?? ''}}</p>
                                    {{-- <a href="https://www.okler.net/" class="btn btn-light btn-outline font-weight-semibold text-color-dark btn-px-5 btn-py-2 border-width-1 text-1 mt-3">LEARN MORE</a> --}}
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>

    <!-- ======= Services Section ======= -->
    <section id="services" class="services mt-5">
        <div class="container">
            <div class="section-title">
                {{-- <span>Valores</span> --}}
                <h2>Valores</h2>
            </div>
            <div class="row justify-content-center">
                @foreach ($valores as $valor)
                    <div class="col-sm-10 col-md-7 col-lg-4 mb-4 mb-lg-0" style="height: 400px; margin-top: 22px">
                        <div class="featured-boxes featured-boxes-modern-style-2 featured-boxes-modern-style-2-hover-only featured-boxes-modern-style-primary my-4" style="height: 400px;">
                            <div class="featured-box">
                                <div class="box-content px-lg-4 px-xl-5 py-lg-5" style="height: 400px;">
                                    <i style="color: {{ $config->secondary_color ?? 'black' }}" class="icon-featured fa-solid fa-leaf"></i>
                                    <h2 class="font-weight-normal text-5"><strong>{{$valor->nome ?? ''}}</strong></h2>
                                    <p class="mb-0" style="text-align: justify;">{{$valor->descricao ?? ''}}</p>
                                    {{-- <a href="https://www.okler.net/" class="btn btn-light btn-outline font-weight-semibold text-color-dark btn-px-5 btn-py-2 border-width-1 text-1 mt-3">LEARN MORE</a> --}}
                                </div>
                            </div>
                        </div>
                    </div>    
                    <br><br>                
                @endforeach
            </div>
        </div>
    </section><!-- End Services Section -->

    <div class="container py-4">
        <div class="row">
            <div class="col">
                <hr class="solid my-5">
            </div>
        </div>
    </div>
    </div>
@endsection


@section('javascript')

@endsection
