
@extends('layouts.base')

@section('icone-modulo',"fa fa-building")

@section('icone','fa fa-houzz')



@section('content')

            <section class="page-header page-header-modern page-header-background page-header-background-md overlay overlay-color-dark overlay-show overlay-op-7" style="background-image: url({{ optional($bunnerItem)->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunnerItem->imagem) : asset('admin/imgDefault.png') }});">
                <div class="container">
                    <div class="row mt-5">
                        <div class="col-md-12 align-self-center p-static order-2 text-center">
                            <h1 class="text-12 font-weight-semibold">Notícia</h1>
                        </div>
                        <div class="col-md-12 align-self-center order-1">
                            <ul class="breadcrumb breadcrumb-light d-block text-center">
                                <li><a href="{{ route('home') }}">Pagina principal</a></li>
                                <li class="active">Notícia</li>
                                <li class="active">Detalhe</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>
            {{-- <div class="row text-center pt-4 mt-5">
                <div class="col">
                    <h2 class="word-rotator slide font-weight-bold text-8 mb-2">
                        <span>FSTPL PARTICIPA NO 16º CONSELHO CONSULTIVO </span>
                        <span class="word-rotator-words bg-primary"></span>
                    </h2>
                </div>
            </div> --}}

            <div class="container mt-4">
                <div class="row">
                    <!-- Coluna principal: Notícia selecionada -->
                    <div class="col-lg-8" id="noticia-detalhes-container" >
                        <!-- Título da Notícia -->
                        <h2 class="word-rotator slide font-weight-bold text-7 mb-2">
                            <span>{{ strtoupper($noticia->titulo) }}</span>
                        </h2>

                        <!-- Data de Publicação -->
                        <p class="slide text-4 mb-4">Data da Publicação: {{ $noticia->data_publicacao }}</p>

                        <!-- Destaque -->
                        @if ($noticia->destaque == 1)
                            <p class="btn btn-dark">Notícia em Destaque</p>
                        @endif

                        <!-- Mídia da Notícia -->
                        @if ($noticia->midias && count($noticia->midias) > 0)
                            <div id="carouselMidiasEvento" class="carousel slide mb-4" data-bs-ride="carousel">
                                <div class="carousel-inner">
                                    @foreach ($noticia->midias->filter(fn($m) => $m->estado == 1) as $index => $media)
                                        <div class="carousel-item {{ $index === 0 ? 'active' : '' }}" style="width: 100%; height: 450px;">
                                            @if (Str::endsWith($media->ficheiro, ['.mp4', '.webm']))
                                                <video autoplay muted loop controls class="w-100" style="height: 100%; height: 450px; object-fit: cover;" preload="metadata">
                                                    <source src="{{ asset('admin/imagens/noticias/midia/' . $media->ficheiro) }}" type="video/mp4">
                                                    Seu navegador não suporta vídeo.
                                                </video>
                                            @elseif ($media->link_video)
                                                <iframe 
                                                    src="{{ $media->link_video }}"
                                                    style="width: 100%; height: 100%; object-fit: cover;"
                                                    title="Vídeo do evento"
                                                    frameborder="0"
                                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                                    allowfullscreen>
                                                </iframe>
                                            @else
                                                <img src="{{ asset('admin/imagens/noticias/midia/' . $media->ficheiro) }}"
                                                    class="img-fluid rounded shadow"
                                                    style="width: 100%; height: 100%; object-fit: cover;"
                                                    alt="Imagem do evento">
                                            @endif
                                        </div>
                                    @endforeach
                                </div>

                                <!-- Controles do Carrossel -->
                                <a class="carousel-control-prev" href="#carouselMidiasEvento" role="button" data-bs-slide="prev">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                </a>
                                <a class="carousel-control-next" href="#carouselMidiasEvento" role="button" data-bs-slide="next">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                </a>
                            </div>
                        @else
                            <!-- Imagem padrão da notícia -->
                            <div class="post-image mb-3 mt-3">
                                <img src="{{ asset('admin/imagens/noticias/' . $noticia->imagem) }}"
                                    class="img-fluid rounded shadow"
                                    style="width: 100%; height: 450px; object-fit: cover;"
                                    alt="Imagem do evento">
                            </div>
                        @endif

                        <!-- Conteúdo da Notícia -->
                        <article class="post post-large pb-5">
                            <!-- Data Formatada -->
                            <div class="post-date mb-2">
                                <span style="color: {{ $config->secondary_color ?? 'black' }}" class="day d-block">
                                    {{ date('d', strtotime($noticia->data_publicacao)) }}
                                </span>
                                <span style="background-color: {{ $config->secondary_color ?? 'black' }}" class="month d-block">
                                    {{ date('M', strtotime($noticia->data_publicacao)) }}
                                </span>
                            </div>

                            <!-- Corpo -->
                            <div class="post-content">
                                <p class="text-muted"><strong>Resumo: </strong>{{ $noticia->resumo }}</p>
                                <p align="justify">{!! $noticia->corpo_noticia ?? '' !!}</p>
                            </div>
                        </article>
                    </div>

            
                    <!-- Coluna lateral: Notícias recentes -->
                    <div class="col-lg-4" >
                        <h4 class="font-weight-bold mb-3">Notícias em Destaques</h4>
                            <ul class="list-unstyled" id="noticias-container">
                                @if (count($noticiasDestaques) < 1 )
                                    <span>Sem notícias em destaques</span>
                                @else
                                    @foreach ($noticiasDestaques as $noticiaRecente)
                                        <div class="col-lg-12 mb-4">
                                            <article class="post post-large pb-5">
                                                <div class="post-image text-center">
                                                    <a href="{{ route('noticias.detalhe', encrypt($noticiaRecente->id)) }}">
                                                        <img src="{{ asset('admin/imagens/noticias/' . $noticiaRecente->imagem) }}" 
                                                            style="width: 500px; height: 200px; object-fit: cover;"
                                                            class="img-fluid img-thumbnail img-thumbnail-no-borders rounded-0" 
                                                            alt="" />
                                                    </a>
                                                </div>
                                        
                                                <div class="post-date text-center">
                                                    <span style="color: {{ $config->secondary_color ?? 'black' }}" class="day d-block">{{ date('d', strtotime($noticiaRecente->data_publicacao)) }}</span>
                                                    <span style="background-color: {{ $config->secondary_color ?? 'black' }}" class="month d-block">{{ date('M', strtotime($noticiaRecente->data_publicacao)) }}</span>
                                                </div>
                                        
                                                <div class="post-content">                                 
                                                    <h4>
                                                        <a href="{{ route('noticias.detalhe', encrypt($noticiaRecente->id)) }}" 
                                                         style="color: {{ $config->secondary_color ?? 'black' }}">
                                                        {{ $noticiaRecente->titulo ?? '' }}
                                                        </a>
                                                    </h4>
                                                    <p class="mb-1 text-justify">
                                                        {{ $noticiaRecente->resumo ?? '' }}
                                                    </p>
                                                    <a href="{{ route('noticias.detalhe', encrypt($noticiaRecente->id)) }}" 
                                                    class="read-more text-color-dark font-weight-bold text-2">
                                                    Ver mais <i class="fas fa-chevron-right text-1 ms-1"></i>
                                                    </a>
                                                </div>
                                            </article>
                                        </div>
                                    @endforeach
                                @endif
                            </ul>
                        </h4>
                    </div>
                </div>
            </div>

            {{-- <div class="row">
                <div class="col">
                    <hr class="solid my-5">
                </div>
            </div> --}}

        </div>








        </div>


@endsection


@section('javascript')
<script>
    const container = document.getElementById('noticias-container');

    dados.noticias.forEach(noticia => {
        const noticiaHTML = `
                <li class="mb-4 ">
                    <p class="text-muted" align="justify">Sem notícias recentes</p>
                </li>
        `;
        container.innerHTML += noticiaHTML;
    });
</script>
@endsection
