@extends('layouts.base')

@section('icone-modulo',"fa fa-calendar")
@section('icone','fa fa-calendar-check')

@section('content')

<section class="page-header page-header-modern page-header-background page-header-background-md overlay overlay-color-dark overlay-show overlay-op-7" 
    style="background-image: url({{ optional($bunnerItem)->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunnerItem->imagem) : asset('admin/imgDefault.png') }});">
    <div class="container">
        <div class="row mt-5">
            <div class="col-md-12 text-center">
                <h1 class="text-12 font-weight-semibold">Eventos | Actividades</h1>
                <ul class="breadcrumb breadcrumb-light d-block text-center">
                    <li><a href="{{ route('home') }}">Página Principal</a></li>
                    <li class="active">Eventos | Actividades</li>
                    <li class="active">Detalhes</li>
                </ul>
            </div>
        </div>
    </div>
</section>

<div class="container mt-4">
        <!-- Coluna principal -->
    <div class="col-lg-10">
        <h2 class="font-weight-bold text-7 mb-2 text-uppercase">{{ $evento->titulo }}</h2>
        <p class="text-4 mb-2">Data do Evento: {{ $evento->data_evento }}</p>

        <h1 class="p-2 badge bg-{{ \Carbon\Carbon::parse($evento->data_evento)->isPast() ? 'secondary' : 'success' }}">
            {{ \Carbon\Carbon::parse($evento->data_evento)->isPast() ? 'Esta actividade já foi realizada!' : 'Esta actividade ainda não aconteceu' }}
        </h1>

        {{-- Imagem principal --}}
        @if ($evento->midias && count($evento->midias) > 0)
            <div id="carouselMidiasEvento" class="carousel slide " data-bs-ride="carousel">
                <div class="carousel-inner">
                    @foreach ($evento->midias->filter(fn($m) => $m->estado == 1) as $index => $media)
                        <div class="carousel-item {{ $index === 0 ? 'active' : '' }}" style="width: 100%; height: 600px;">
                            @if (Str::endsWith($media->ficheiro, ['.mp4', '.webm']))
                                <video autoplay muted loop controls class="w-100" style="width: 100%; height: 100%; object-fit: cover;"  preload="metadata">
                                    <source src="{{ asset('admin/eventos/midia/' . $media->ficheiro) }}" type="video/mp4">
                                    Seu navegador não suporta vídeo.
                                </video>
                            @elseif ($media->link_video)
                                <iframe 
                                    style="width: 100%; height: 100%; object-fit: cover;"
                                    src="{{ $media->link_video }}"
                                    title="Vídeo do evento"
                                    frameborder="0"
                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                    allowfullscreen>
                                </iframe>
                            @else
                                <img src="{{ asset('admin/eventos/midia/' . $media->ficheiro) }}" 
                                    class="img-fluid rounded shadow" 
                                    style="width: 100%; height: 100%; object-fit: cover;"
                                    alt="Imagem do evento">
                            @endif
                            
                        </div>
                    @endforeach
                </div>
                <a class="carousel-control-prev" href="#carouselMidiasEvento" role="button" data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                </a>
                <a class="carousel-control-next" href="#carouselMidiasEvento" role="button" data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                </a>
            </div>
        @else
            <div class="post-image mb-3 mt-3">
                <img src="{{ asset('admin/eventos/' . $evento->imagem) }}" 
                    class="img-fluid rounded shadow" 
                    style="width: 100%; height: 450px; object-fit: cover;"
                    alt="Imagem do evento">
            </div>
        @endif

        {{-- Conteúdo do Evento --}}
        <div class="post-content">
            <p class="text-muted"><strong>Resumo: </strong>{{ $evento->resumo }}</p>
            <p align="justify">{!! $evento->detalhe_evento !!}</p>
        </div>

        {{-- Carrossel de imagens e vídeos --}}
        

        {{-- Exemplo: botão confirmar presença (opcional) --}}
        {{-- 
        @if (!\Carbon\Carbon::parse($evento->data_evento)->isPast())
            <a href="#" class="btn btn-primary mt-3">Confirmar Presença</a>
        @endif 
        --}}
    </div>
</div>

@endsection

