@extends('layouts.base')

@section('icone-modulo', 'fa fa-building')

@section('icone', 'fa fa-houzz')



@section('content')

    <section
        class="page-header page-header-modern page-header-background page-header-background-md parallax overlay overlay-color-dark overlay-show overlay-op-5 mt-0"
        data-plugin-parallax data-plugin-options="{'speed': 1.2}"
        data-image-src="{{ optional($bunnerItem)->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunnerItem->imagem) : asset('admin/imgDefault.png') }}">
        <div class="container">
            <div class="row">
                <div class="col-md-12 align-self-center p-static order-2 text-center">
                    <h1 class="text-12 font-weight-semibold"> Contactos </h1>
                    {{-- <span class="sub-title">Envie-nos sua Preocupação.</span> --}}
                </div>
                <div class="col-md-12 align-self-center order-1">
                    <ul class="breadcrumb breadcrumb-light d-block text-center">
                        <li><a href="{{ route('home') }}">Página Principal</a></li>
                        <li class="active">Contactos</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    </div>
    </div>

    </div>

    <div class="container">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        @if (session('success'))
            <div class="alert alert-success">
                <ul>
                    <li>{{ session('success') }}</li>
                </ul>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger">
                <ul>
                    <li>{{ session('error') }}</li>
                </ul>
            </div>
        @endif
        <div class="row py-4">
            <div class="col-lg-7 appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="650">

                <div class="offset-anchor" id="contact-sent"></div>


                <form action="{{ route('contacto.store') }}" method="POST">
                    @csrf

                    {{-- <h2 class="font-weight-bold text-7 mt-2 mb-0">Contacte-nos</h2> --}}
                    <p class="mb-4">Sinta-se à vontade para colocar qualquer questão!</p>

                    {{-- <form id="contactFormAdvanced" action="#" method="POST" enctype="multipart/form-data">
                            <input type="hidden" value="true" name="emailSent" id="emailSent"> --}}
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label class="form-label mb-1 text-2">Nome Completo</label>
                            <input type="text" value="" data-msg-required="Please enter your name." maxlength="100"
                                class="form-control text-3 h-auto py-2" name="nome" id="nome" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label class="form-label mb-1 text-2">Email</label>
                            <input type="email" value="" data-msg-required="Please enter your email address."
                                data-msg-email="Please enter a valid email address." maxlength="100"
                                class="form-control text-3 h-auto py-2" name="email" id="email" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-12">
                            <label class="form-label mb-1 text-2">Contacto</label>
                            <input type="contacto" value="" data-msg-required="informe seu contacto." maxlength="12"
                                class="form-control text-3 h-auto py-2" name="contacto" id="contacto" required>
                        </div>
                    </div>
                    {{-- <div class="row">
                                <div class="form-group col-md-12">
                                    <label class="form-label mb-1 text-2">Assunto</label>
                                    <select data-msg-required="Please enter the subject."
                                        class="form-control text-3 h-auto py-2" name="subject" id="subject"
                                        required>
                                        <option value="">...</option>
                                        <option value="Option 1">Option 1</option>
                                        <option value="Option 2">Option 2</option>
                                        <option value="Option 3">Option 3</option>
                                        <option value="Option 4">Option 4</option>
                                    </select>
                                </div>
                            </div> --}}



                    <div class="row">
                        <div class="form-group col-md-12 mb-4">
                            <label class="form-label mb-1 text-2">Mensagem</label>
                            <textarea maxlength="5000" data-msg-required="Please enter your message." rows="6"
                                class="form-control text-3 h-auto py-2" name="mensagem" id="mensagem" required></textarea>
                        </div>
                    </div>
                    {{-- @if ($errors->any())
                            <ul class="text-danger">
                                @foreach ($errors->all() as $error)
                                    <li class="text-danger">{{ $error }}</li>
                                @endforeach
                            </ul>
                        @endif --}}

                    {{-- @error('valor')
                        <span class="text-danger">
                            {{ $message }}
                        </span>
                    @enderror --}}

                    @if (config('services.recaptcha.key'))
                        <div class="g-recaptcha" data-sitekey="{{ config('services.recaptcha.key') }}">
                        </div>
                    @endif

                    @if (Session::has('g-recaptcha-response'))
                        <p class="alert {{ Session::get('alert-class', 'alert-info') }}">
                            {{ Session::get('g-recaptcha-response') }}
                        </p>
                    @endif
                    <div class="row">
                        <div class="form-group col-md-12 mb-5" >
                            <input type="submit" id="contactFormSubmit" value="Enviar"
                                style="background-color: {{ $config->secondary_color ?? 'black' }}; color: {{ $config->primary_color ?? 'white' }};"
                                class="btn btn-modern pull-right" data-loading-text="Loading...">
                        </div>
                    </div>
                </form>

            </div>
            <div class="col-lg-5">
                <!--
                            <div class="overflow-hidden mb-1">
                                <h4 class="text-primary mb-0 appear-animation" data-appear-animation="maskUp"
                                    data-appear-animation-delay="200">Saiba <strong>Nós</strong></h4>
                            </div>
                            <div class="overflow-hidden mb-3">
                                <p class="lead text-4 mb-0 appear-animation" data-appear-animation="maskUp"
                                    data-appear-animation-delay="400">Venha conhecer nosso escritório.</p>
                            </div>
                            <div class="overflow-hidden">
                                <p class="mb-0 appear-animation" data-appear-animation="maskUp"
                                    data-appear-animation-delay="600">Faça-nos uma visita.</p>
                            </div>
                            -->

                <div class="appear-animation" data-appear-animation="fadeInUpShorter" data-appear-animation-delay="800">
                    <h4 style="color: {{ $config->secondary_color ?? 'black' }}" class=" pt-5"><strong>Nosso Escritório</strong></h4>
                    <ul class="list list-icons list-icons-style-3">
                        <li><i style="background-color: {{ $config->secondary_color ?? 'black' }}" class="fas fa-map-marker-alt"></i> <strong>Endereço:</strong> {{$contacto->endereco ?? 'Não definido'}}</li>
                        {{-- <li><i class="fas fa-phone top-6"></i> <strong>Telefone:</strong> (+244) 222 456-789</li> --}}
                        <li><i style="background-color: {{ $config->secondary_color ?? 'black' }}" class="fas fa-envelope"></i> <strong>Email Geral:</strong>
                            <a > <span style="color: {{ $config->secondary_color ?? 'black' }}">{{$contacto->emailGeral ?? 'Não definido'}}</span></a>

                        </li>
                        <li><i style="background-color: {{ $config->secondary_color ?? 'black' }}" class="fas fa-envelope"></i> <strong>Email de Suporte:</strong>
                            <a ><span style="color: {{ $config->secondary_color ?? 'black' }}">{{$contacto->emailSuporte ?? 'Não definido'}}</span></a>
                        </li>
                        <li><i style="background-color: {{ $config->secondary_color ?? 'black' }}" class="fas fa-phone"></i> <strong>Nº Telefone:</strong>
                            <a href="#"><span style="color: {{ $config->secondary_color ?? 'black' }}">{{$contacto->telefone ?? 'Não definido'}}</span></a>
                        </li>
                    </ul>

                    <!--<div class="row lightbox mt-4 mb-0 pb-0"
                                    data-plugin-options="{'delegate': 'a', 'type': 'image', 'gallery': {'enabled': true}}">
                                    <div class="col-md-4 mb-4 mb-md-0">
                                        <a class="img-thumbnail p-0 border-0 d-block"
                                            href="{{ asset('frontend/img/office/our-office-1.jpg') }}"
                                            data-plugin-options="{'type':'image'}">
                                            <img class="img-fluid"
                                                src="{{ asset('frontend/img/office/our-office-1.jpg') }}" alt="Office">
                                        </a>
                                    </div>
                                    <div class="col-md-4 mb-4 mb-md-0">
                                        <a class="img-thumbnail p-0 border-0 d-block"
                                            href="{{ asset('frontend/img/office/our-office-2.jpg') }}"
                                            data-plugin-options="{'type':'image'}">
                                            <img class="img-fluid"
                                                src="{{ asset('frontend/img/office/our-office-2.jpg') }}" alt="Office">
                                        </a>
                                    </div>
                                    <div class="col-md-4">
                                        <a class="img-thumbnail p-0 border-0 d-block"
                                            href="{{ asset('frontend/img/office/our-office-3.jpg') }}"
                                            data-plugin-options="{'type':'image'}">
                                            <img class="img-fluid"
                                                src="{{ asset('frontend/img/office/our-office-3.jpg') }}" alt="Office">
                                        </a>
                                    </div>
                                </div>-->

                    {{-- <h4 class="text-primary pt-5"><strong>Horário de Atendimento</strong></h4>
                            <ul class="list list-icons list-dark mt-2">
                                <li><i class="far fa-clock top-6"></i> Segunda-feira a Sexta-feira - 8h ás 15h</li>
                                {{-- <li><i class="far fa-clock top-6"></i> Sábado - 9h ás 12h</li>
                                <li><i class="far fa-clock top-6"></i> Domingo - Encerrado</li>
                            </ul> --}}
                </div>

            </div>

        </div>

    </div>

    <!-- Google Maps - Go to the bottom of the page to change settings and map location. -->
    <!--<div id="googlemaps" class="google-map m-0" style="height: 650px;"></div>-->

    {{-- <div style="width: 100%"><iframe width="100%" height="600" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q=Av.%204%20de%20Fevereiro%20N%C2%BA%2042%20%E2%80%A2%20Luanda%20%E2%80%A2%20ANGOLA+(FSTPL%20-%20Fundo%20Social%20dos%20Funcion%C3%A1rios%20e%20Trabalhadores%20do%20Sector%20dos%20Transportes)&amp;t=h&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"><a href="https://www.gps.ie/">gps tracker sport</a></iframe></div> --}}

    <div class="col-lg-12">
        <iframe
            class="mb-4 mb-lg-0"
            src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q={{ $contacto->latitude ?? ''}},{{ $contacto->longitude ?? ''}}&amp;t=h&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"
            frameborder="0"
            style="border:0; width: 100%; height: 384px;"
            allowfullscreen>
        </iframe>
    </div>

    </div>


@endsection


@section('javascript')
    <script src='https://www.google.com/recaptcha/api.js'></script>
@endsection
