@extends('admin.layouts.platform')

@section('title', 'Valores')

@section('subtitle','Detalhes')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Missão, Visão</span></li>
                    <li><span>Valores</span></li>
                    <li><span>Detalhes</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <div class="card-actions">
                            {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                            <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                        </div>
                        <h2 class="card-title">Detalhe do Valores</h2>
                        {{-- <p class="card-subtitle">
                            Este é um exemplo de formulário com múltiplos campos organizados em colunas.
                        </p> --}}
                    </header>
                    <div class="card-body">
                        <div class="row">
                            {{-- <div class="col-lg-4 text-center d-flex align-items-center justify-content-center">
                                <div>
                                    <h5 class="mb-1">Imagem</h5>
                                    <div class="position-relative">
                                        <img id="imagePreview" 
                                        src="{{ $valor->foto ? asset('admin/imagens/valores/'.$valor->foto) : asset('admin/imagens/users/default.png') }}" 
                                            class=" border border-3 mb-3" 
                                        style="width: 230px; height: 250px; background-repeat: no-repeat; background-size: cover;"  
                                            alt="Preview">
                                    </div>
                                </div>
                            </div> --}}
        
                            <!-- Coluna dos Inputs -->
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="nomeCompleto">Nome</label>
                                            <input type="text" class="form-control" id="nome" name="nome" value="{{ $valor->nome ?? '' }}" placeholder="Digite o nome" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="estado">Estado</label>
                                            <input type="text" class="form-control" id="estado" name="estado" value="{{ $valor->estado ? 'Activo' : 'Inativo' }}" placeholder="Digite o nome de utilizador" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="biografia" class="form-label">Descrição</label>
                                        <textarea class="form-control" id="descricao" name="descricao" rows="6" placeholder="Digite a Descrição" maxlength="300" readonly>{{ $valor->descricao ?? '' }}</textarea>
                                        {{-- <small id="counterDescricao" class="form-text text-muted mt-1">0 / 300 caracteres</small> --}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <footer class="card-footer text-end">
                        <a href="{{ route('valores.index') }}" class="btn btn-dark">Voltar</a>
                        <a href="{{ route('valores.edit', encrypt($valor->id)) }}" class="btn btn-warning">Editar</a>
                    </footer>
                </section>
            </div>
        </div>
        <!-- end: page -->
    </section>
    <script src="{{ asset("admin/js/Validacao/membroComissao.js")}}"></script>
@endsection

    
