@extends('admin.layouts.platform')

@section('title', 'Perfil')

@section('subtitle','Ver')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>PERFIL</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Utilizadores</span></li>
                <li><span>Perfil</span></li>
                <li><span>Ver</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>

    @if(session('error'))
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                text: '{{ session('error') }}',
                confirmButtonText: 'Fechar'
            })
        </script>
    @endif
    @if(session('success'))
        <script>
            Swal.fire({
                title: 'SUCESSO',
                icon: 'success',
                text: '{{ session('success') }}',
                confirmButtonText: 'Fechar'
            })
        </script>
    @endif
    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-4 col-xl-3 mb-4 mb-xl-0">

            <section class="card">
                <div class="card-body">
                    <div class="thumb-info mb-3">
                        <img
                            src="{{ $user->foto ? asset('admin/imagens/users/'. $user->foto) : asset('admin/imagens/users/default.png')  }}"
                            class="rounded img-fluid"
                            alt="{{ $user->name_completo ?? ""}}"
                            style="width: 300px; height: 300px; object-fit: cover;"
                        >
                        <div class="thumb-info-title">
                            <span class="thumb-info-inner">{{ $user->name_completo ?? ""}}</span>
                            <span class="thumb-info-type">{{ $user->role->name ?? ""}}</span>
                        </div>
                    </div>

                    <div class="widget-toggle-expand mb-3">
                        <div class="widget-header">
                            <h5 class="mb-2 font-weight-semibold text-dark">Informações Pessoais</h5>
                            <div class="widget-toggle">+</div>
                        </div>
                        <div class="widget-content-expanded">
                            <ul class=" mt-1">
                                <li > <strong>Telefone:</strong>  {{ $user->telefone ?? ""}}</li>
                                <li > <strong>Email::</strong> {{ $user->email ?? ""}}</li>
                            </ul>
                        </div>
                    </div>

                    <div class="widget-toggle-expand mb-3">
                        <div class="widget-header">
                            <h5 class="mb-2 font-weight-semibold text-dark">Definições de Sistema</h5>
                            <div class="widget-toggle">+</div>
                        </div>
                        <div class="widget-content-expanded">
                            <ul class=" mt-1">
                                {{-- <li > <strong>Telefone:</strong>  {{ $user->telefone ?? ""}}</li>
                                <li > <strong>Email::</strong> {{ $user->email ?? ""}}</li> --}}
                               
                                @if ($notify->tipo == '1')
                                    <li > <strong>Notifição Por:</strong> {{ "SMS's"}}</li>
								@elseif ($notify->tipo == '2')  
                                    <li > <strong>Notifição Por:</strong> {{ "EMAIL"}}</li>
								@endif
                            </ul>
                        </div>
                    </div>

                    <hr class="dotted short">
                </div>
            </section>
        </div>
        <div class="col-lg-8 col-xl-8">
            <div class="tabs">
                <ul class="nav nav-tabs tabs-primary">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#overview" role="tab"
                                    aria-selected="false"> Utilizador</a>
                        {{-- <button class="nav-link" data-bs-target="#overview" data-bs-toggle="tab"></button> --}}
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#edit" role="tab"
                            aria-selected="false">
                            </i> Reset Palavra-Passe
                        </a>
                        {{-- <button class="nav-link" data-bs-target="#edit" data-bs-toggle="tab">Reset Palavra-Passe</button> --}}
                    </li>
                </ul>
                <div class="tab-content">
                    <div id="overview" class="tab-pane active" role="tabpanel">
                        <div class="p-3">
                            <h4 class="mb-3 font-weight-semibold text-dark">Informações de Utilizador</h4>

                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="nomeCompleto">Nome Completo</label>
                                            <input type="text" class="form-control" id="nomeCompleto" name="nome" value="{{ $user->name_completo ?? '' }}" placeholder="Digite o nome" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="username">Nome de Utilizador</label>
                                            <input type="text" class="form-control" id="username" name="username" value="{{ $user->username ?? '' }}" placeholder="Digite o nome de utilizador" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label class="col-form-label" for="telefone">Perfil</label>
                                            <input type="text" class="form-control" id="perfil" name="perfil" value="{{ $user->role->name ?? ''}}" placeholder="Digite o número de telefone" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if(Auth::id() == $user->id)
                        <div id="edit" class="tab-pane" role="tabpanel">
                            <div class="col-lg-12">
                                <section class="card">
                                    <div class="text-center mt-2">
                                        <h5 class="text-primary">Alterar Palavra-Passe</h5>
                                        <p class="text-muted">Sua nova Palavra-Passe deve ser diferente da Palavra-Passe usada anteriormente.</p>
                                        <p class="text-danger">Depois de alterar a Palavra-Passe, termine a secção e poderá usar a nova credêncial.</p>
                                    </div>

                                    <div class="card-body">
                                        <form action="{{route("reset.pass.Myperfil.store")}}" method="POST">
                                            @csrf
                                            <div class="row mb-4">
                                                <div class="col-md-6">
                                                    <label class="form-label" for="password-input">Email</label>
                                                    <div class="position-relative auth-pass-inputgroup">
                                                        <input type="" class="form-control pe-5" value="{{$user->email ?? ''}}" placeholder="Digite a palavra-passe" id="email-input" name="email" aria-describedby="emailInput" required readonly>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label" for="password-input">Palavra-Passe Actual</label>
                                                    <div class="position-relative auth-pass-inputgroup">
                                                        <input type="password" class="form-control pe-5" value="" placeholder="Digite a Palavra-Passe actual" id="email-input" name="passAnt" required>
                                                        <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" id="password-addon"><i class="ri-eye-fill align-middle"></i></button>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label class="form-label" for="password-input">Palavra-Passe Nova</label>
                                                    <div class="position-relative auth-pass-inputgroup">
                                                        <input type="password" class="form-control pe-5 password-input" oninput="validaPassword(this)" onpaste="return false" placeholder="Digite a Palavra-Passe" id="password-input" name="pass" aria-describedby="passwordInput" required>
                                                        <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" id="password-addon"><i class="ri-eye-fill align-middle"></i></button>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label" for="confirm-password-input">Confirmar Palavra-Passe Nova</label>
                                                    <div class="position-relative auth-pass-inputgroup mb-3">
                                                        <input type="password" class="form-control pe-5 password-input" oninput="checkPassword(this)" onpaste="return false" placeholder="Confirmar a Palavra-Passe" id="confirm-password-input" name="novaPass" required>
                                                        <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" id="confirm-password-input"><i class="ri-eye-fill align-middle"></i></i></button>
                                                        <div class="invalid-feedback">As senhas devem ser iguais</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="password-contain" class="p-3 bg-light mb-2 rounded" style="display: none;">
                                                <h5 class="fs-13">A Palavra-Passe deve conter:</h5>
                                                <p id="pass-length" class="required fs-12 mb-2">No mínimo <b>8 caracteres</b></p><br>
                                                <p id="pass-special" class="required fs-12 mb-2">Pelo menos 1 caracter <b>especial</b> (!@#$%^&*(),.?":{}|<>)</p><br>
                                                <p id="pass-lower" class="required fs-12 mb-2">Pelo menos uma letra <b>minúscula</b> (a-z)</p><br>
                                                <p id="pass-upper" class="required fs-12 mb-2">Pelo menos uma letra <b>maiúscula</b> (A-Z)</p><br>
                                                <p id="pass-number" class="required fs-12 mb-0">Pelo menos um <b>número</b> (0-9)</p>
                                            </div>
                                            <footer class="card-footer text-end">
                                                <button type="submit" class="btn btn-warning" id="btnSubmite" disabled>Salvar Alterações</button>
                                            </footer>
                                        </form>
                                    </div>
                                </section>
                            </div>
                        </div>
                    @else
                        <div id="edit" class="tab-pane" role="tabpanel">
                            <div class="col-lg-12">
                                <section class="card">
                                    <div class="text-center mt-2">
                                        <h5 class="text-primary">Alterar Palavra-Passe</h5>
                                        <p class="text-muted">A Palavra-Passe deve ser diferente da Palavra-Passe usada anteriormente.</p>
                                    </div>

                                    <div class="card-body">
                                        <form action="{{route("reset.pass.perfil.store")}}" method="POST">
                                            @csrf
                                            <div class="row mb-4">
                                                <div class="col-md-12">
                                                    <label class="form-label" for="password-input">Email</label>
                                                    <div class="position-relative auth-pass-inputgroup">
                                                        <input type="" class="form-control pe-5" value="{{$user->email ?? ''}}" placeholder="Digite a palavra-passe" id="email-input" name="email" aria-describedby="emailInput" required readonly>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label class="form-label" for="password-input">Palavra-Passe Nova</label>
                                                    <div class="position-relative auth-pass-inputgroup">
                                                        <input type="password" class="form-control pe-5 password-input" oninput="validaPassword(this)" onpaste="return false" placeholder="Digite a Palavra-Passe" id="password-input" name="pass" aria-describedby="passwordInput" required>
                                                        <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" id="password-addon"><i class="ri-eye-fill align-middle"></i></button>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label" for="confirm-password-input">Confirmar Palavra-Passe Nova</label>
                                                    <div class="position-relative auth-pass-inputgroup mb-3">
                                                        <input type="password" class="form-control pe-5 password-input" oninput="checkPassword(this)" onpaste="return false" placeholder="Confirmar a Palavra-Passe" id="confirm-password-input" name="novaPass" required>
                                                        <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" id="confirm-password-input"><i class="ri-eye-fill align-middle"></i></i></button>
                                                        <div class="invalid-feedback">As senhas devem ser iguais</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="password-contain" class="p-3 bg-light mb-2 rounded" style="display: none;">
                                                <h5 class="fs-13">A Palavra-Passe deve conter:</h5>
                                                <p id="pass-length" class="required fs-12 mb-2">No mínimo <b>8 caracteres</b></p><br>
                                                <p id="pass-special" class="required fs-12 mb-2">Pelo menos 1 caracter <b>especial</b> (!@#$%^&*(),.?":{}|<>)</p><br>
                                                <p id="pass-lower" class="required fs-12 mb-2">Pelo menos uma letra <b>minúscula</b> (a-z)</p><br>
                                                <p id="pass-upper" class="required fs-12 mb-2">Pelo menos uma letra <b>maiúscula</b> (A-Z)</p><br>
                                                <p id="pass-number" class="required fs-12 mb-0">Pelo menos um <b>número</b> (0-9)</p>
                                            </div>
                                            <footer class="card-footer text-end">
                                                <button type="submit" class="btn btn-warning" id="btnSubmite" disabled>Salvar Alterações</button>
                                            </footer>
                                        </form>
                                    </div>
                                </section>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

    </div>
    <!-- end: page -->
</section>

<script src="{{ asset("admin/js/Validacao/alterarPasse.js")}}"></script>
@endsection

