@extends('admin.layouts.platform')

@section('title', 'Utilizadores')

@section('subtitle','Listagem')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Utilizadores</span></li>
                    <li><span>Listagem</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        @if (session('success'))
            <script>
                Swal.fire({
                    title: 'Sucesso',
                    icon:'success',
                    text: '{{ session('success') }}',
                    confirmButtonText: 'Fechar'
                })
            </script>
        @endif

        <!-- start: page -->
        <div class="row" style="padding-top: 80px;">
            <div class="col">
                <section class="card">
                    <header class="card-header">
                        <div class="card-actions">
                            {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a> --}}
                        </div>
                        <h2 class="card-title">Listagem de Utilizadores</h2>
                    </header>
                    <div class="card-body">
                        {{-- <div class="row">
                            <div class="col-sm-6">
                                <div class="mb-3">
                                </div>
                            </div>
                        </div> --}}
                        <table class="table table-bordered table-striped mb-0" id="datatable-tabletools">
                            <thead>
                                <a id="addToTable" class="btn btn-dark" href="{{ route('utilizadors.create')}}">Adicionar Novo Utilizador <i class="fas fa-plus"></i></a>
                                <tr>
                                    <th>#</th>
                                    <th>Nome Completo</th>
                                    <th>Nome Utilizador</th>
                                    <th>Perfil</th>
                                    <th>Estado</th>
                                    <th>Acção</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($users as $user)
                                    @if (Gate::allows('isAdmin') || ($user->role->id != 1 && $user->role->id != 4) )
                                        <tr>
                                            <td> {{ $loop->index + 1 }}</td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <!-- Avatar -->
                                                    <img src="{{ $user->foto ? asset('admin/imagens/users/'. $user->foto) : asset('admin/imagens/users/default.png')  }}"
                                                        class="rounded-circle border border-3 me-2"
                                                        style="width: 30px; height: 30px; object-fit: cover;"
                                                        alt="Avatar">
                                                    <!-- Nome Completo -->
                                                    <span>{{ $user->name_completo ?? '' }}</span>
                                                </div>
                                            </td>
                                            <td><a href="{{ route('admin.user.perfil', encrypt($user->id)) }}" style="color: #3490dc; text-decoration: underline; font-weight: bold;">{{ $user->username ?? '' }}</a></td>
                                            <td> {{ $user->role->name ?? '' }}</td>
                                            @if ($user->isActive)
                                                <td><span class="badge badge-success">Activo</span></td>
                                            @else
                                                <td><span class="badge badge-danger">Inativo</span></td>
                                            @endif
                                            <td class="actions">
                                                <a href="{{ route('utilizadors.show', encrypt($user->id))}}"><i class="fa-solid fa-eye"></i></a>
                                                <a href="{{ route('utilizadors.edit', encrypt($user->id))}}"><i class="fas fa-pencil-alt"></i></a>
                                                @if (Auth::id() != $user->id)
                                                    <a class="mb-1 mt-1 me-1 modal-basic" href="#modalEliminar{{$user->id}}"><i class="far fa-trash-alt"></i></a>
                                                @endif
                                            </td>

                                            <div id="modalEliminar{{$user->id}}" class="modal-block modal-block-danger mfp-hide">
                                                <section class="card">
                                                    <header class="card-header">
                                                        <h2 class="card-title">AVISO!</h2>
                                                    </header>
                                                    <div class="card-body">
                                                        <div class="modal-wrapper">
                                                            <div class="modal-icon">
                                                                <i class="fas fa-times-circle"></i>
                                                            </div>
                                                            <div class="modal-text">
                                                                <h4 class="font-weight-bold text-dark">AVISO</h4>
                                                                <p>Deseja realmente eliminar este Utilizador?</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <form action="{{ route('utilizadors.destroy', encrypt($user->id)) }}" method="post">
                                                        @csrf
                                                        @method('DELETE')
                                                        <footer class="card-footer">
                                                            <div class="row">
                                                                <div class="col-md-12 text-end">
                                                                    <button class="btn btn-dark modal-dismiss">Cancelar </button>
                                                                    <button type="submit" class="btn btn-danger">Sim, Elimine-o</button>
                                                                </div>
                                                            </div>
                                                        </footer>
                                                    </form>
                                                </section>
                                            </div>
                                        </tr>
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>

        <!-- end: page -->
    </section>
@endsection



@section('javascript')


@endsection
