<!doctype html>
<html class="fixed">

<head>

		<!-- Basic -->
		<meta charset="UTF-8">

        <title>{{ $config->portal_nome ?? 'N2BS - Template'}} | Alteração da Palavra-Passe</title>

		<meta name="keywords" content="porto do lobito Portal" />
		<meta name="description" content="Porto do Lubito">
    	<meta name="author" content="n2bs.ao">

		<!-- Favicon -->
		<link rel="shortcut icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}" type="image/x-icon" />
    	<link rel="apple-touch-icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}">


		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />

		<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

		<!-- Web Fonts  -->
		<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="{{ asset('admin/vendor/bootstrap/css/bootstrap.css')}}" />
		<link rel="stylesheet" href="{{ asset('admin/vendor/animate/animate.compat.css')}} ">
		<link rel="stylesheet" href="{{ asset('admin/vendor/font-awesome/css/all.min.css')}}"/>
		<link rel="stylesheet" href="{{ asset('admin/vendor/boxicons/css/boxicons.min.css')}}"/>
		<link rel="stylesheet" href="{{ asset('admin/vendor/magnific-popup/magnific-popup.css')}} " />
		<link rel="stylesheet" href="{{ asset('admin/vendor/bootstrap-datepicker/css/bootstrap-datepicker3.css')}} " />

		<!-- Specific Page Vendor CSS -->

		<!-- Theme CSS -->
		<link rel="stylesheet" href="{{ asset('admin/css/theme.css')}} " />

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="{{ asset('admin/css/custom.css')}} ">

		<!-- Head Libs -->
		<script src="{{ asset('admin/vendor/modernizr/modernizr.js')}} "></script>

		<script src="{{ asset('admin/master/style-switcher/style.switcher.localstorage.js')}} "></script>

	</head>
	<body style="background-image: url('{{ isset($entidadeBackground) && $entidadeBackground->logo ? asset('admin/endidadesIMG/'. $entidadeBackground->logo) : asset('admin/imgDefault.png')  }}'); background-repeat: no-repeat; background-size: cover;">
		<!-- start: page -->
		<section class="body-sign">
            @if(session('error'))
				<script>
					Swal.fire({
						title: 'AVISO',
						icon: 'warning',
						text: '{{ session('error') }}',
						confirmButtonText: 'Fechar'
					})
				</script>
			@endif
			@if(session('success'))
				<script>
					Swal.fire({
						title: 'SUCESSO',
						icon: 'success',
						text: '{{ session('success') }}',
						confirmButtonText: 'Fechar'
					})
				</script>
			@endif

			<div class="center-sign">
				{{-- <a href="#" class="logo float-start">
					<img src="{{ asset('StyleCreateAccount/images/logo_AssociaT.png')}}" height="100" alt="AssociaT admin" />
				</a> --}}

				<div class="panel card-sign">
					<a href="{{ route('login')}}" class="logo float-start d-flex align-items-start p-3">
						<img 
							src="{{ isset($entidadeVisual) && $entidadeVisual->logo ? asset('admin/endidadesIMG/'. $entidadeVisual->logo) : asset('admin/imgDefault.png')  }}" 
							height="55" 
							alt="{{ $entidadeVisual->nome ?? 'SISTEMA' }}" 
							class="align-self-start"
						>
					</a>
					<div class="card-title-sign mt-3 text-end" style="background-color: rgb(255, 255, 255)">
						<h2 class="title text-uppercase font-weight-bold m-0" style="background-color: black"><i class="bx bx-user-circle me-1 text-6 position-relative top-5"></i> Redefinir</h2>
					</div>
					<div class="card-body">
						<div>
							<h5 class="text-primary text-center">Alterar Palavra-Passe</h5>
							<p class="text-muted text-center">Sua nova Palavra-Passe deve ser diferente da Palavra-Passe usada anteriormente.</p>
						</div>

						<form action="{{route("auth.reset.resetars.store")}}" method="POST">
							@csrf
							<div class="mb-3">
								@if ($notify->tipo == '1')
									<label class="form-label visually-hidden" for="password-input">Número de Telefone</label>
								@elseif ($notify->tipo == '2')  
									<label class="form-label visually-hidden" for="password-input">Email</label>
								@endif
								<div class="position-relative auth-pass-inputgroup">
									<input type="hidden" class="form-control pe-5" value="{{$username}}" placeholder="Digite a palavra-passe" id="email-input" name="username" aria-describedby="emailInput" required>
								</div>
							</div>

							<div class="mb-3">
								<label class="form-label" for="password-input">Palavra-Passe Nova</label>
								<div class="position-relative auth-pass-inputgroup">
									<input type="password" class="form-control pe-5 password-input" oninput="validaPassword(this)" onpaste="return false" placeholder="Digite a Palavra-Passe" id="password-input" name="pass" aria-describedby="passwordInput" required>
									<button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" id="password-addon"><i class="ri-eye-fill align-middle"></i></button>
								</div>
							</div>

							<div class="mb-3">
								<label class="form-label" for="confirm-password-input">Confirmar Palavra-Passe Nova</label>
								<div class="position-relative auth-pass-inputgroup mb-3">
									<input type="password" class="form-control pe-5 password-input" oninput="checkPassword(this)" onpaste="return false" placeholder="Confirmar a Palavra-Passe" id="confirm-password-input" name="novaPass" required>
									<button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" id="confirm-password-input"><i class="ri-eye-fill align-middle"></i></button>
									<div class="invalid-feedback">As senhas devem ser iguais</div>
								</div>
							</div>
							<div id="password-contain" class="p-3 bg-light mb-2 rounded" style="display: none">
								<h5 class="fs-13">A Palavra-Passe deve conter:</h5>
								<p id="pass-length" class="required fs-12 mb-2">No minimo <b>8 caracteres</b></p><br>
								<p id="pass-special" class="invalid fs-12 mb-2">Pelo menos 1 caracter <b>especial</b> (!@#$%^&*(),.?":{}|<>)</p>
								<p id="pass-lower" class="required fs-12 mb-2">Pelo menos uma letra <b>minúscula</b> (a-z)</p><br>
								<p id="pass-upper" class="required fs-12 mb-2">Pelo menos uma letra <b>maiúscula</b> (A-Z)</p><br>
								<p id="pass-number" class="required fs-12 mb-0">Pelo menos um <b>número</b> (0-9)</p>
							</div>

							<footer class="card-footer text-end">
								<button type="submit" id="btnSubmite" class="btn btn-warning">Submeter</button>
							</footer>
							<p class="text-center mt-3">Lembrou a sua Palavra-Passe? <a href="{{ route("login")}}">Faça Login</a></p>
							<p class="text-center text-muted mt-3 mb-3">&copy; {{date('Y')}} {{ $config->copyright ?? 'N2BS - Template'}}</p>
						</form>
					</div>
				</div>
			</div>
		</section>
		<!-- end: page -->

		<!-- Vendor -->
		<script src="{{ asset('admin/vendor/jquery/jquery.js')}}"></script>
		<script src="{{ asset('admin/vendor/jquery-browser-mobile/jquery.browser.mobile.js')}}"></script>
		<script src="{{ asset('admin/vendor/jquery-cookie/jquery.cookie.js')}}"></script>
		<script src="{{ asset('admin/master/style-switcher/style.switcher.js')}}"></script>
		<script src="{{ asset('admin/vendor/popper/umd/popper.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/bootstrap-datepicker/js/bootstrap-datepicker.js')}}"></script>
		<script src="{{ asset('admin/vendor/common/common.js')}}"></script>
		<script src="{{ asset('admin/vendor/nanoscroller/nanoscroller.js')}}"></script>
		<script src="{{ asset('admin/vendor/magnific-popup/jquery.magnific-popup.js')}}"></script>
		<script src="{{ asset('admin/vendor/jquery-placeholder/jquery.placeholder.js')}}"></script>

		<!-- Specific Page Vendor -->


		<!-- Theme Base, Components and Settings -->
		<script src="{{ asset('admin/js/theme.js')}} "></script>

		<!-- Theme Custom -->
		<script src="{{ asset('admin/js/js/custom.js')}} "></script>

		<!-- Theme Initialization Files -->
		<script src="{{ asset('admin/js/theme.init.js')}} "></script>

		<script src="{{ asset("admin/js/Validacao/alterarPasse.js")}}"></script>

		<!-- Analytics to Track Preview Website -->
		<script>
		  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
		  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
		  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
		  })(window,document,'script','../../../../www.google-analytics.com/analytics.js','ga');

		  ga('create', 'UA-42715764-8', 'auto');
		  ga('send', 'pageview');
		</script>

	</body>

</html>
