<!doctype html>
<html class="fixed">

<head>

		<!-- Basic -->
		<meta charset="UTF-8">

        <title>{{ $config->portal_nome ?? 'N2BS - Template'}} | Login</title>

		<meta name="keywords" content="porto do lobito Portal" />
		<meta name="description" content="Porto do Lubito">
    	<meta name="author" content="n2bs.ao">

		<!-- Favicon -->
		<link rel="shortcut icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}" type="image/x-icon" />
    	<link rel="apple-touch-icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}">

		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />

		<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

		<!-- Web Fonts  -->
		<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="{{ asset('admin/vendor/bootstrap/css/bootstrap.css')}}" />
		<link rel="stylesheet" href="{{ asset('admin/vendor/animate/animate.compat.css')}} ">
		<link rel="stylesheet" href="{{ asset('admin/vendor/font-awesome/css/all.min.css')}}"/>
		<link rel="stylesheet" href="{{ asset('admin/vendor/boxicons/css/boxicons.min.css')}}"/>
		<link rel="stylesheet" href="{{ asset('admin/vendor/magnific-popup/magnific-popup.css')}} " />
		<link rel="stylesheet" href="{{ asset('admin/vendor/bootstrap-datepicker/css/bootstrap-datepicker3.css')}} " />

		<!-- Specific Page Vendor CSS -->

		<!-- Theme CSS -->
		<link rel="stylesheet" href="{{ asset('admin/css/theme.css')}} " />

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="{{ asset('admin/css/custom.css')}} ">

		<!-- Head Libs -->
		<script src="{{ asset('admin/vendor/modernizr/modernizr.js')}} "></script>

		<script src="{{ asset('admin/master/style-switcher/style.switcher.localstorage.js')}} "></script>

	</head>
	<body style="background-image: url('{{ isset($entidadeBackground) && $entidadeBackground->logo ? asset('admin/endidadesIMG/'. $entidadeBackground->logo) : asset('admin/imgDefault.png')  }}'); background-repeat: no-repeat; background-size: cover;">
		<!-- start: page -->
		<section class="body-sign">
            @if ($errors->any())
                <script>
                    Swal.fire({
                        title: 'AVISO',
                        icon: 'warning',
                        html: `
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        `,
                        confirmButtonText: 'Fechar'
                    });
                </script>
            @endif

			<div class="center-sign" >
				

				<div class="panel card-sign">
					{{-- <a href="{{ route('login')}}" class="logo float-start" >
						<img src="{{ isset($entidadeVisual) && $entidadeVisual->logo ? asset('admin/endidadesIMG/'. $entidadeVisual->logo) : asset('admin/imgDefault.png')  }}" height="50" alt="{{ $entidadeVisual->nome ?? 'SISTEMA' }}" >
						<img src="{{ asset('StyleCreateAccount/images/logo_AssociaT.png')}}" height="100" alt="AssociaT admin" />
					</a> --}}
					<a href="{{ route('login')}}" class="logo float-start d-flex align-items-start p-3">
						<img 
							src="{{ isset($entidadeVisual) && $entidadeVisual->logo ? asset('admin/endidadesIMG/'. $entidadeVisual->logo) : asset('admin/imgDefault.png')  }}" 
							height="55" 
							alt="{{ $entidadeVisual->nome ?? 'SISTEMA' }}" 
							class="align-self-start"
						>
					</a>
					<div class="card-title-sign mt-3 text-end"  style="background-color: rgb(255, 255, 255)">
						<h2 class="title text-uppercase font-weight-bold m-0" style="background-color: black"><i class="bx bx-user-circle me-1 text-6 position-relative top-5"></i> Login</h2>
					</div>
					<div class="card-body">
						<form action="{{ route('auth.login') }}" method="POST">
                            @csrf
							<div class="form-group mb-3">
								<label>Nome de Utilizador ou Email</label>
								<div class="input-group">
									<input name="username" type="text" class="form-control " placeholder="Digite o Nome de Utilizador ou o Email" />
									<span class="input-group-text">
										<i class="bx bx-user text-4"></i>
									</span>
								</div>
							</div>

							<div class="form-group mb-3">
								<div class="clearfix">
									<label class="float-start">Palavra-Passe</label>
									<a href="{{ route("auth.reset")}}" class="float-end text-decoration-underline">Esqueceu a sua Palavra-Passe?</a>
								</div>
								<div class="input-group">
									<input name="password" type="password" class="form-control" placeholder="Digite a Palavra-Passe" />
									<span class="input-group-text">
										<i class="bx bx-lock text-4"></i>
									</span>
								</div>
							</div>

							<div class="row">
								<div class="col-sm-8">
									{{-- <div class="checkbox-custom checkbox-default">
										<input id="RememberMe" name="rememberme" type="checkbox"/>
										<label for="RememberMe">Remember Me</label>
									</div> --}}
								</div>
								<div class="col-sm-4 text-end">
									<button type="submit" class="btn btn-dark mt-2">Entrar</button>
								</div>
								<a href="{{ route('home') }}" class="btn btn-link text-decoration-underline">Voltar ao Portal </a>
								<p class="text-center text-mute mt-3 mb-3">&copy; {{date('Y')}} {{ $config->copyright ?? 'N2BS - Template'}}</p>
							</div>

							{{-- <span class="mt-3 mb-3 line-thru text-center text-uppercase">
								<span>or</span>
							</span> --}}

							{{-- <div class="mb-1 text-center">
								<a class="btn btn-facebook mb-3 ms-1 me-1" href="#">Connect with <i class="fab fa-facebook-f"></i></a>
							</div> --}}

							{{-- <p class="text-center">Don't have an account yet? <a href="pages-signup.html">Sign Up!</a></p> --}}

						</form>
					</div>
				</div>
			</div>
		</section>
		<!-- end: page -->

		<!-- Vendor -->
		<script src="{{ asset('admin/vendor/jquery/jquery.js')}}"></script>
		<script src="{{ asset('admin/vendor/jquery-browser-mobile/jquery.browser.mobile.js')}}"></script>
		<script src="{{ asset('admin/vendor/jquery-cookie/jquery.cookie.js')}}"></script>
		<script src="{{ asset('admin/master/style-switcher/style.switcher.js')}}"></script>
		<script src="{{ asset('admin/vendor/popper/umd/popper.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/bootstrap-datepicker/js/bootstrap-datepicker.js')}}"></script>
		<script src="{{ asset('admin/vendor/common/common.js')}}"></script>
		<script src="{{ asset('admin/vendor/nanoscroller/nanoscroller.js')}}"></script>
		<script src="{{ asset('admin/vendor/magnific-popup/jquery.magnific-popup.js')}}"></script>
		<script src="{{ asset('admin/vendor/jquery-placeholder/jquery.placeholder.js')}}"></script>

		<!-- Specific Page Vendor -->


		<!-- Theme Base, Components and Settings -->
		<script src="{{ asset('admin/js/theme.js')}} "></script>

		<!-- Theme Custom -->
		<script src="{{ asset('admin/js/js/custom.js')}} "></script>

		<!-- Theme Initialization Files -->
		<script src="{{ asset('admin/js/theme.init.js')}} "></script>

		<!-- Analytics to Track Preview Website -->
		<script>
		  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
		  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
		  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
		  })(window,document,'script','../../../../www.google-analytics.com/analytics.js','ga');

		  ga('create', 'UA-42715764-8', 'auto');
		  ga('send', 'pageview');
		</script>
	</body>

</html>
