<!doctype html>
<html class="fixed">

<head>

		<!-- Basic -->
		<meta charset="UTF-8">

        <title>{{ $config->portal_nome ?? 'N2BS - Template'}} | Confirmação</title>

		<meta name="keywords" content="porto do lobito Portal" />
		<meta name="description" content="Porto do Lubito">
    	<meta name="author" content="n2bs.ao">

		<!-- Favicon -->
		<link rel="shortcut icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}" type="image/x-icon" />
    	<link rel="apple-touch-icon" href="{{ $config->shortcut_icon ? asset('/admin/endidadesIMG/app-config/' . $config->shortcut_icon) : asset('admin/imgDefault.png') }}">


		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />

		<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

		<!-- Web Fonts  -->
		<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="{{ asset('admin/vendor/bootstrap/css/bootstrap.css')}}" />
		<link rel="stylesheet" href="{{ asset('admin/vendor/animate/animate.compat.css')}} ">
		<link rel="stylesheet" href="{{ asset('admin/vendor/font-awesome/css/all.min.css')}}"/>
		<link rel="stylesheet" href="{{ asset('admin/vendor/boxicons/css/boxicons.min.css')}}"/>
		<link rel="stylesheet" href="{{ asset('admin/vendor/magnific-popup/magnific-popup.css')}} " />
		<link rel="stylesheet" href="{{ asset('admin/vendor/bootstrap-datepicker/css/bootstrap-datepicker3.css')}} " />

		<!-- Specific Page Vendor CSS -->

		<!-- Theme CSS -->
		<link rel="stylesheet" href="{{ asset('admin/css/theme.css')}} " />

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="{{ asset('admin/css/custom.css')}} ">

		<!-- Head Libs -->
		<script src="{{ asset('admin/vendor/modernizr/modernizr.js')}} "></script>

		<script src="{{ asset('admin/master/style-switcher/style.switcher.localstorage.js')}} "></script>

	</head>
	<body style="background-image: url('{{ isset($entidadeBackground) && $entidadeBackground->logo ? asset('admin/endidadesIMG/'. $entidadeBackground->logo) : asset('admin/imgDefault.png')  }}'); background-repeat: no-repeat; background-size: cover;">
		<!-- start: page -->
		<section class="body-sign">
            @if(session('error'))
				<script>
					Swal.fire({
						title: 'AVISO',
						icon: 'warning',
						text: '{{ session('error') }}',
						confirmButtonText: 'Fechar'
					})
				</script>
			@endif
			@if(session('success'))
				<script>
					Swal.fire({
						title: 'SUCESSO',
						icon: 'success',
						text: '{{ session('success') }}',
						confirmButtonText: 'Fechar'
					})
				</script>
			@endif

			<div class="center-sign">
				{{-- <a href="#" class="logo float-start">
					<img src="{{ asset('StyleCreateAccount/images/logo_AssociaT.png')}}" height="100" alt="AssociaT admin" />
				</a> --}}

				<div class="panel card-sign">
					<a href="{{ route('login')}}" class="logo float-start d-flex align-items-start p-3">
						<img 
							src="{{ isset($entidadeVisual) && $entidadeVisual->logo ? asset('admin/endidadesIMG/'. $entidadeVisual->logo) : asset('admin/imgDefault.png')  }}" 
							height="55" 
							alt="{{ $entidadeVisual->nome ?? 'SISTEMA' }}" 
							class="align-self-start"
						>
					</a>
					<div class="card-title-sign mt-3 text-end" style="background-color: rgb(255, 255, 255)">
						<h2 class="title text-uppercase font-weight-bold m-0" style="background-color: black"><i class="bx bx-user-circle me-1 text-6 position-relative top-5"></i> Confirmação</h2>
					</div>
					<div class="card-body">
						<div class="text-muted text-center mb-4 mx-lg-3">
							@if ($notify->tipo == '1')
								<h4 class="text-primary">Verifique o Telefone</h4>
								<p>Por favor, digite o código que foi enviado para <span class="fw-semibold text-primary">{{$username}}</span></p>
							@else
								<h4 class="text-primary">Verifique a caixa de Email</h4>
								<p>Por favor, digite o código que foi enviado para <span class="fw-semibold text-primary">{{$username}}</span></p>
							@endif
							{{-- <h4 class="text-primary">Verifique o seu Email</h4>
							<p>Por favor, digite o código que foi enviado para <span class="fw-semibold text-primary">{{$email}}</span></p> --}}
						</div>

						<div class="mt-4">
							<form action="{{ route('auth.reset.confirmarCodigo.store') }}" method="POST">
								@csrf
								<div class="d-flex justify-content-center">
									<div class="mb-3 me-2">
										<label for="digit1-input12" class="visually-hidden">Digito 1</label>
										<input type="hidden" class="form-control form-control-lg bg-light border-light text-center" value="{{$username}}" id="username" name="username" style="width: 50px;" id="digit1-input12">
									</div>
									<div class="mb-3 me-2">
										<label for="digit1-input" class="visually-hidden">Digito 1</label>
										<input type="text" class="form-control form-control-lg bg-light border-light text-center" name="digit1" style="width: 50px;" onkeyup="moverParaProximo(1, event)" maxLength="1" id="digit1-input" required>
									</div>
									<div class="mb-3 me-2">
										<label for="digit2-input" class="visually-hidden">Digito 2</label>
										<input type="text" class="form-control form-control-lg bg-light border-light text-center" name="digit2" style="width: 50px;" onkeyup="moverParaProximo(2, event)" maxLength="1" id="digit2-input" required>
									</div>
									<div class="mb-3 me-2">
										<label for="digit3-input" class="visually-hidden">Digito 3</label>
										<input type="text" class="form-control form-control-lg bg-light border-light text-center" name="digit3" style="width: 50px;" onkeyup="moverParaProximo(3, event)" maxLength="1" id="digit3-input" required>
									</div>
									<div class="mb-3 me-2">
										<label for="digit4-input" class="visually-hidden">Digito 4</label>
										<input type="text" class="form-control form-control-lg bg-light border-light text-center" name="digit4" style="width: 50px;" onkeyup="moverParaProximo(4, event)" maxLength="1" id="digit4-input" required>
									</div>
									<div class="mb-3 me-2">
										<label for="digit5-input" class="visually-hidden">Digito 5</label>
										<input type="text" class="form-control form-control-lg bg-light border-light text-center" name="digit5" style="width: 50px;" onkeyup="moverParaProximo(5, event)" maxLength="1" id="digit5-input" required>
									</div>
									<div class="mb-3 me-2">
										<label for="digit6-input" class="visually-hidden">Digito 6</label>
										<input type="text" class="form-control form-control-lg bg-light border-light text-center" name="digit6" style="width: 50px;" onkeyup="moverParaProximo(6, event)" maxLength="1" id="digit6-input" required>
									</div>
								</div>

								<div class="text-center">
									<button type="submit" class="btn btn-dark mt-2">Confirmar</button>
								</div>
							</form>
							<div class="mt-4 text-center">
								<p class="mb-0">Reenviar código? <a href="{{route("reenviar.codigo", encrypt($username))}}" class="fw-semibold text-primary text-decoration-underline">Reeviar</a> </p>
								<p class="text-center text-muted mt-3 mb-3">&copy; {{date('Y')}} {{ $config->copyright ?? 'N2BS - Template'}}</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- end: page -->

		<!-- Vendor -->
		<script src="{{ asset('admin/vendor/jquery/jquery.js')}}"></script>
		<script src="{{ asset('admin/vendor/jquery-browser-mobile/jquery.browser.mobile.js')}}"></script>
		<script src="{{ asset('admin/vendor/jquery-cookie/jquery.cookie.js')}}"></script>
		<script src="{{ asset('admin/master/style-switcher/style.switcher.js')}}"></script>
		<script src="{{ asset('admin/vendor/popper/umd/popper.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{ asset('admin/vendor/bootstrap-datepicker/js/bootstrap-datepicker.js')}}"></script>
		<script src="{{ asset('admin/vendor/common/common.js')}}"></script>
		<script src="{{ asset('admin/vendor/nanoscroller/nanoscroller.js')}}"></script>
		<script src="{{ asset('admin/vendor/magnific-popup/jquery.magnific-popup.js')}}"></script>
		<script src="{{ asset('admin/vendor/jquery-placeholder/jquery.placeholder.js')}}"></script>

		<!-- Specific Page Vendor -->


		<!-- Theme Base, Components and Settings -->
		<script src="{{ asset('admin/js/theme.js')}} "></script>

		<!-- Theme Custom -->
		<script src="{{ asset('admin/js/js/custom.js')}} "></script>

		<!-- Theme Initialization Files -->
		<script src="{{ asset('admin/js/theme.init.js')}} "></script>

		<!-- Analytics to Track Preview Website -->
		<script>
		  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
		  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
		  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
		  })(window,document,'script','../../../../www.google-analytics.com/analytics.js','ga');

		  ga('create', 'UA-42715764-8', 'auto');
		  ga('send', 'pageview');
		</script>

		<script>
			function moverParaProximo(currentInput, event) {
				const input = document.getElementById(`digit${currentInput}-input`);
				const nextInput = document.getElementById(`digit${currentInput + 1}-input`);
				const prevInput = document.getElementById(`digit${currentInput - 1}-input`);

				// Se a tecla pressionada não for "Backspace" e o input atual estiver preenchido, vai para o próximo
				if (event.key !== "Backspace" && input.value.length === 1 && nextInput) {
					nextInput.focus();
				}
				// Se a tecla for "Backspace" e o campo estiver vazio, volta para o anterior
				else if (event.key === "Backspace" && input.value.length === 0 && prevInput) {
					prevInput.focus();
				}
			}
		</script>
	</body>

</html>
