@extends('admin.layouts.platform')

@section('title', 'Perguntas Frequentes')

@section('subtitle','Editar')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Perguntas Frequentes</span></li>
                    <li><span>Editar</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('perguntas-frequentes.update', encrypt($faq->id))}}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                            </div>
                            <h2 class="card-title">Editar Pergunta Frequênte</h2>
                            {{-- <p class="card-subtitle">
                                Este é um exemplo de formulário com múltiplos campos organizados em colunas.
                            </p> --}}
                        </header>
                        <div class="card-body">
                            <div class="row mb-3">            
                                <!-- Coluna dos Inputs -->
                                <div class="col-lg-12">
                                    <div class="row">
                                        <div class="col-lg-6 ">
                                            <div class="form-group">
                                                <label class="col-form-label" for="nomeCompleto">Pergunta</label>
                                                <input type="text" class="form-control" id="pergunta" value="{{ $faq->pergunta ?? '' }}" name="pergunta" placeholder="Digite a pergunta" required>
                                                <small class="form-text required mt-1">Escreva a Pergunta sem "?"</small>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <label for="estado" class="col-form-label">Estado</label>
                                            <select class="form-select" id="estado" name="estado" required>
                                                <option value="" disabled selected>Selecione o estado</option>
                                                <option value="1" {{ $faq->estado ? 'selected' : '' }}>Activo</option>
                                                <option value="0" {{ !$faq->estado ? 'selected' : '' }}>Inativo</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 mb-3">
                                <label for="resumo" class="form-label">Resposta</label>
                                <textarea class="form-control" id="resposta" name="resposta" rows="6" placeholder="Digite a resposta" maxlength="500" required>{{ $faq->resposta }}</textarea>
                                <small id="respostaCounter" class="form-text text-muted mt-1">0 / 500 caracteres</small>
                            </div>
                        </div>
                        <footer class="card-footer text-end">
                            <a href="{{ route('perguntas-frequentes.index') }}" class="btn btn-dark">Voltar</a>
                            <button type="submit" class="btn btn-warning">Salvar Alterações</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>

        <!-- end: page -->
    </section>
    <script src="{{ asset("admin/js/Validacao/faq.js")}}"></script>
@endsection
