@extends('admin.layouts.platform')

@section('title', 'Parceiro')

@section('subtitle','Detalhes')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Parceiro</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Detalhes do Parceiro</h2>
                </header>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 text-center d-flex align-items-center justify-content-center">
                            <div>
                                <h5 class="mb-3">Imagm do Parceiro</h5>
                                <img src="{{ $parceiro->imagem ? asset('admin/imagens/parceiros/'.$parceiro->imagem) : asset('admin/imagens/users/default.png') }}" 
                                     class="border border-3 mb-3"
                                     style="width: 150px; height: 150px; object-fit: cover;" 
                                     alt="Foto do Parceiro">
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="row">
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="nomeCompleto">Nome do Parceiro</label>
                                        <input type="text" class="form-control" id="nome" name="nome" value="{{ $parceiro->nome ?? ''}}" placeholder="Digite o nome do parceiro" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="username">Endereço</label>
                                        <input type="text" class="form-control" id="endereco" name="endereco" value="{{ $parceiro->endereco ?? ''}}" placeholder="Digite o endereço" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="telefone">Telefone</label>
                                        <input type="text" class="form-control" id="telefone" name="telefone" value="{{ $parceiro->telefone ?? ''}}" placeholder="Digite o número de telefone" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="estado">Estado</label>
                                        <input type="text" class="form-control" id="estado" name="estado" value="{{ $parceiro->estado ? 'Activo' : 'Inativo'}}" placeholder="Digite o estado" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-12 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="site">Site</label>
                                        <input type="text" class="form-control" id="site" name="site" value="{{ $parceiro->site ?? ''}}" placeholder="Digite o site" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="col-form-label" for="categoria">Categoria do Parceiro</label>
                                        <input type="text" class="form-control" id="categoria" name="categoria" value="{{ $parceiro->categoriaParceiros->nome ?? ''}}" placeholder="Digite a categoria do parceiro" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="card-footer text-end">
                    <a href="{{ route('parceiro.index') }}" class="btn btn-dark">Voltar</a>
                    <a href="{{ route('parceiro.edit', encrypt($parceiro->id)) }}" class="btn btn-warning">Editar</a>
                </footer>
            </section>
        </div>
    </div>
    <!-- end: page -->
</section>
@endsection
