@extends('admin.layouts.platform')

@section('title', 'Notícias')

@section('subtitle', 'Editar')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>Editar Notícia</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Notícias</span></li>
                <li><span>Editar</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif

    <div class="row" style="padding-top: 80px;">
        <form action="{{ route('noticia.update', encrypt($noticia->id)) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h2 class="card-title">Editar Notícia</h2>
                    </header>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-4 text-center d-flex justify-content-center">
                                <div>
                                    <h4 class="mt-2">Imagem da Notícia</h4>
                                    <div class="position-relative">
                                        <!-- Preview da imagem -->
                                        <img id="imagePreview" 
                                            src="{{ $noticia->imagem ? asset('admin/imagens/noticias/' . $noticia->imagem) : asset('admin/imagens/users/default.png') }}" 
                                            class=" border border-3 m-1" 
                                        {{-- class="rounded-circle border border-3 mb-3"  --}}
                                            style="width: 230px; height: 300px; background-repeat: no-repeat; background-size: cover;" 
                                            alt="Preview">
                                    </div>
                                    <!-- Botão de seleção -->
                                    <label for="imageUpload" class="btn btn-dark mt-2">Alterar Imagem</label>
                                    <input type="file" id="imageUpload" value="{{ $noticia->imagem }}" accept="image/*" name="foto" class="form-control d-none" onchange="previewImage(event)">
                                    
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for="titulo" class="form-label">Título</label>
                                        <input type="text" class="form-control" id="titulo" maxlength="145" name="titulo" value="{{ $noticia->titulo }}" required>
                                        <small id="counterTitulo" class="form-text text-muted mt-1">0 / 145 caracteres</small>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="data_publicacao" class="form-label">Data de Publicação</label>
                                        <input type="date" class="form-control" id="data_publicacao" max="<?php echo date('Y-m-d'); ?>" name="data_publicacao" value="{{ $noticia->data_publicacao }}" required>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="destaque" class="form-label">Destaque</label>
                                        <select class="form-select" id="destaque" name="destaque" required>
                                            <option value="1" {{ $noticia->destaque ? 'selected' : '' }}>Sim</option>
                                            <option value="0" {{ !$noticia->destaque ? 'selected' : '' }}>Não</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="estado" class="form-label">Estado</label>
                                        <select class="form-select" id="estado" name="estado" required>
                                            <option value="1" {{ $noticia->estado ? 'selected' : '' }}>Activo</option>
                                            <option value="0" {{ !$noticia->estado ? 'selected' : '' }}>Inativo</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="resumo" class="form-label">Resumo</label>
                                        <textarea class="form-control" id="resumo" name="resumo" rows="6" maxlength="315" required>{{ old('resumo', $noticia->resumo ?? '') }}</textarea>
                                        <small id="counterResumo" class="form-text text-muted mt-1">0 / 315 caracteres</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 mt-3">
                                <label for="corpo_noticia" class="form-label">Corpo da Notícia</label>
                                <textarea class="form-control" id="corpo_noticia" name="corpo_noticia" rows="5" >{{ old('corpo_noticia', $noticia->corpo_noticia ?? '') }}</textarea>
                            </div>
                        </div>
                    </div>

                    <footer class="card-footer text-end">
                        <a href="{{ route('noticia.index') }}" class="btn btn-dark">Voltar</a>
                        <button class="btn btn-warning">Salvar Alterações</button>
                    </footer>
                </section>
            </div>
        </form>
    </div>
</section>

<script src="{{ asset("admin/js/Validacao/noticia.js")}}"></script>
<script src="{{ asset('tinymceEditor/js/tinymce/tinymce.min.js') }}"></script>
<script>
    tinymce.init({
        selector: 'textarea#corpo_noticia',
        height: 400,
        menubar: false,
        license_key: 'gpl',
        plugins: 'advlist autolink lists link charmap preview anchor searchreplace visualblocks code fullscreen insertdatetime table wordcount',
        toolbar: 'undo redo | formatselect | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | preview',
        branding: false,

        content_style: `
            body {
                font-family: Arial, sans-serif;
                font-size: 16px;
                line-height: 1.4;
                color: #333;
            }

            p {
                margin: 0 0 7px 0;
            }

            ul, ol {
                color: #333;
                margin: 0 0 10px 20px;
            }

            li {
                color: black;
                margin-bottom: 5px;
            }
        `
        
    });
</script>
@endsection
