@extends('admin.layouts.platform')

@section('title', 'Mídias da Noticia')

@section('subtitle', 'Detalhes')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>Detalhes da Mídia</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Noticia</span></li>
                <li><span>Mídias da Noticia</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>

    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Visualização da Mídias da Noticia</h2>
                </header>

                <div class="card-body">
                    <div class="row">
                        <!-- Coluna da Mídia Atual -->
                        <div class="col-lg-4 text-center d-flex justify-content-center">
                            <div>
                                <span class="mt-2 d-block fw-bold">Ficheiro</span>
                                <div class="position-relative">
                                    <div class="border border-3 m-1"
                                        style="width: 330px; height: 250px; object-fit: cover; background-color: #f1f1f1; display: flex; align-items: center; justify-content: center;">
                                        
                                        @if(Str::endsWith($midia->ficheiro, ['.mp4', '.webm']))
                                            <video src="{{ asset('admin/imagens/noticias/midia/' . $midia->ficheiro) }}"
                                                style="width: 100%; height: 100%; object-fit: cover;" controls></video>
                                        @else
                                            <img src="{{ asset('admin/imagens/noticias/midia/' . $midia->ficheiro) }}"
                                                style="width: 100%; height: 100%; object-fit: cover;" alt="Ficheiro">
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Coluna das Informações -->
                        <div class="col-lg-8">
                            <div class="row">
                                <!-- Evento relacionado -->
                                <div class="col-lg-12 mb-3">
                                    <label for="titulo" class="form-label">Noticia</label>
                                    <input type="text" class="form-control" id="link" maxlength="200" value="{{ $midia->noticia->titulo ?? '—' }}" name="link" placeholder="Digite o evento" readonly>                                    
                                </div>

                                <div class="col-lg-12 mb-3">
                                    <label for="titulo" class="form-label">Link do video (Opcional)</label>
                                    <input type="text" class="form-control" id="link" maxlength="200" value="{{ $midia->link_video ?? ''}}" name="link" placeholder="Digite o link" readonly>
                                    <small id="counterTitulo" class="form-text text-muted mt-1">Caso o video seje muito pesado</small>
                                </div>

                                <!-- Estado -->
                                <div class="col-lg-12 mb-3">
                                    <label class="form-label fw-bold">Estado</label>
                                    <p class="form-control-plaintext">
                                        @if ($midia->estado === 1)
                                            <span class="badge bg-success">Activo</span>
                                        @elseif ($midia->estado === 0)
                                            <span class="badge bg-secondary">Inativo</span>
                                        @else
                                            —
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <footer class="card-footer text-end">
                    <a href="{{ route('midias-noticias.index') }}" class="btn btn-dark">Voltar</a>
                    <a href="{{ route('midias-noticias.edit', encrypt($midia->id)) }}" class="btn btn-warning">Editar</a>
                </footer>
            </section>
        </div>
    </div>
</section>

@endsection
