@extends('admin.layouts.platform')

@section('title', 'Mídias de Eventos')

@section('subtitle','Registro')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Eventos</span></li>
                    <li><span>Mídias</span></li>
                    <li><span>Registro</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('midias-eventos.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                            </div>
                            <h2 class="card-title">Registro de Mídias</h2>
                            {{-- <p class="card-subtitle">
                                Este é um exemplo de formulário com múltiplos campos organizados em colunas.
                            </p> --}}
                        </header>

                        <div class="card-body">
                            <div class="row">
                                <!-- Coluna da Imagem Principal -->
                                <div class="col-lg-4 text-center d-flex justify-content-center">
                                    <div>
                                        <span class="mt-2">Ficheiro</span>
                                        <div class="position-relative">
                                            <div id="previewContainer" class="border border-3 m-1"
                                                style="width: 330px; height: 250px; object-fit: cover; background-color: #f1f1f1; display: flex; align-items: center; justify-content: center;">
                                                <img src="{{ asset('admin/imagens/users/default.png')}}" 
                                                    id="defaultPreview"
                                                    style="width: 100%; height: 100%; object-fit: cover;" alt="Preview">
                                            </div>
                                        </div>

                                        <label for="imageUpload" class="btn btn-dark mt-2">Selecionar o ficheiro</label>
                                        <input type="file" id="imageUpload" accept="image/*,video/*" name="imagem" 
                                            class="form-control d-none" onchange="previewFile(event)" >
                                    </div>
                                </div>
                                <!-- Coluna dos Inputs -->
                                <div class="col-lg-8">
                                    <div class="row">
                                        <div class="col-lg-12 mb-3">
                                            <div class="form-group">
                                                <label for="cargo" class="form-label">Evento</label>
                                                <select name="evento_id" class="form-control" title="Por favor, selecione um cargo" required>
                                                    <option selected disabled value="">Selecione um </option>
                                                    @foreach ($eventos as $evento)
                                                        <option value="{{ $evento->id }}"> {{ $evento->titulo }}</option>    
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-lg-12 mb-3">
                                            <label for="titulo" class="form-label">Link do video (Opcional)</label>
                                            <input type="text" class="form-control" id="link" maxlength="200" name="link" placeholder="Digite o link">
                                            <small id="counterTitulo" class="form-text text-muted mt-1">Caso o video seje muito pesado</small>
                                        </div>

                                        {{-- <div class="col-lg-6 mb-3">
                                            <label for="estado" class="form-label">Tipo de Mídia</label>
                                            <select class="form-select" id="estado" name="tipo" required>
                                                <option value="" disabled selected>Selecione um</option>
                                                <option value="1">Video</option>
                                                <option value="0">Imagem</option>
                                            </select>
                                        </div> --}}

                                        <div class="col-lg-12 mb-3">
                                            <label for="estado" class="form-label">Estado</label>
                                            <select class="form-select" id="estado" name="estado" required>
                                                <option value="" disabled selected>Selecione o estado</option>
                                                <option value="1">Activo</option>
                                                <option value="0">Inativo</option>
                                            </select>
                                        </div>
                                    </div>
                                    <label class="form-text mt-1" style="color: red">Não pode submeter ficheiro com mais de 8MB</label>
                                </div>
                            </div>
                        </div>


                        <footer class="card-footer text-end">
                            <a href="{{ route('midias-eventos.index') }}" class="btn btn-dark">Voltar</a>
                            <button class="btn btn-warning">Submeter</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>

        <!-- end: page -->
    </section>

    {{-- <script src="{{ asset("admin/js/Validacao/noticia.js")}}"></script> --}}
    <script>
        function previewFile(event) {
        const file = event.target.files[0];
        const previewContainer = document.getElementById('previewContainer');

        if (!file) return;

        const fileType = file.type;
        const reader = new FileReader();

        reader.onload = function (e) {
            // Limpar o container
            previewContainer.innerHTML = '';

            if (fileType.startsWith('image/')) {
                const img = document.createElement('img');
                img.src = e.target.result;
                img.style.width = '100%';
                img.style.height = '100%';
                img.style.objectFit = 'cover';
                previewContainer.appendChild(img);
            } else if (fileType.startsWith('video/')) {
                const video = document.createElement('video');
                video.src = e.target.result;
                video.controls = true;
                video.style.width = '100%';
                video.style.height = '100%';
                previewContainer.appendChild(video);
            } else {
                previewContainer.innerHTML = '<p>Formato não suportado</p>';
            }
        };

        reader.readAsDataURL(file);
        }
        </script>

@endsection

