@extends('admin.layouts.platform')

@section('title', 'Mensagem do PCA')

@section('subtitle','Detalhes')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Mensagem do PCA</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>

    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Detalhes da Mensagem do PCA</h2>
                </header>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 text-center d-flex justify-content-center">
                            <img src="{{ $mensagem->imagem ? asset('admin/imagens/membrosComissao/' . $mensagem->imagem) : asset('admin/imagens/membrosComissao/default.png') }}"
                                class="border border-3 mb-1"
                                style="width: 230px; height: 300px; background-repeat: no-repeat; background-size: cover;" 
                                alt="Imagem da notícia">
                        </div>
                        <div class="col-lg-8">
                            <div class="row">
                                <div class="col-lg-8 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="nomeCompleto">PCA</label>
                                        <input type="text" class="form-control" id="beneficio" value="{{$mensagem->nome ?? ''}}" name="beneficio" placeholder="Digite o Benefício" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-4 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="estado">Estado</label>
                                        <input type="text" class="form-control" id="estado" name="estado" value="{{ $mensagem->estado ? 'Activo' : 'Inativo'}}" placeholder="Digite o estado" readonly>
                                    </div>
                                </div>

                                <div class="col-lg-12 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="lema">Lema</label>
                                        <input type="text" class="form-control" id="lema" value="{{$mensagem->lema ?? ''}}" maxlength="200" name="lema" placeholder="Digite o lema" readonly>
                                    </div>
                                </div>

                                
                                <div class="col-lg-12 mb-3">
                                    <label for="mensagem" class="col-form-label">Mensagem</label>
                                    <textarea class="form-control" id="mensagem" name="mensagem" rows="15" placeholder="Digite a mensagem" readonly>{{$mensagem->mensagem ?? ''}}</textarea>
                                    {{-- <small id="counterResumo" class="form-text text-muted mt-1">0 / 315 caracteres</small> --}}
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <footer class="card-footer text-end">
                    <a href="{{ route('mensagem-pca.index') }}" class="btn btn-dark">Voltar</a>
                    <a href="{{ route('mensagem-pca.edit', encrypt($mensagem->id))  }}" class="btn btn-warning">Editar</a>
                </footer>
            </section>
        </div>
    </div>
</section>

{{-- <script src="{{ asset("admin/js/Validacao/parceiro.js")}}"></script> --}}
<script src="{{ asset('tinymceEditor/js/tinymce/tinymce.min.js') }}"></script>
<script>
    tinymce.init({
        selector: 'textarea#mensagem',
        height: 400,
        menubar: false,
        license_key: 'gpl',
        plugins: 'advlist autolink lists link charmap preview anchor searchreplace visualblocks code fullscreen insertdatetime table wordcount',
        toolbar: 'undo redo | formatselect | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | preview',
        branding: false,

        content_style: `
            body {
                font-family: Arial, sans-serif;
                font-size: 16px;
                line-height: 1.4;
                color: #333;
            }

            p {
                margin: 0 0 7px 0;
            }

            ul, ol {
                color: #333;
                margin: 0 0 10px 20px;
            }

            li {
                color: black;
                margin-bottom: 5px;
            }
        `
        
    });
</script>
@endsection