@extends('admin.layouts.platform')

@section('title', 'Membros da Comissão')

@section('subtitle','Registro')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Estrutura Orgânica</span></li>
                    <li><span>Membro da Comissão</span></li>
                    <li><span>Registro</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('membros-comissao.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                            </div>
                            <h2 class="card-title">Registro de Membros da Comissão</h2>
                            {{-- <p class="card-subtitle">
                                Este é um exemplo de formulário com múltiplos campos organizados em colunas.
                            </p> --}}
                        </header>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-4 text-center d-flex align-items-center justify-content-center">
                                    <div>
                                        <h5 class="mb-3">Carregar Foto</h5>
                                        <div class="position-relative">
                                            <!-- Preview da imagem -->
                                            <img id="imagePreview" src="{{ asset('admin/imagens/users/default.png')}}" 
                                                class=" border border-3 mb-3" 
                                            {{-- class="rounded-circle border border-3 mb-3"  --}}
                                            style="width: 230px; height: 300px; background-repeat: no-repeat; background-size: cover;"  
                                                alt="Preview">
                                        </div>
                                        <!-- Botão de seleção -->
                                        <label for="imageUpload" class="btn btn-primary ">Selecionar Imagem</label>
                                        <input type="file" id="imageUpload" accept="image/*"  name="foto" required
                                            class="form-control d-none" onchange="previewImage(event)">
                                    </div>
                                </div>
            
                                <!-- Coluna dos Inputs -->
                                <div class="col-lg-8">
                                    <div class="row">
                                        <div class="col-lg-8 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="nomeCompleto">Nome Completo</label>
                                                <input type="text" class="form-control" id="nome" name="nome" placeholder="Digite o nome" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 mb-3">
                                            <label for="estado" class="col-form-label">Estado</label>
                                            <select class="form-select" id="estado" name="estado" required>
                                                <option value="" disabled selected>Selecione um</option>
                                                <option value="1">Activo</option>
                                                <option value="0">Inativo</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-12 mb-3">
                                            <div class="form-group">
                                                <label for="cargo" class="form-label">Cargo</label>
                                                <select id="cargo" name="cargo" class="form-control" title="Por favor, selecione um cargo" required>
                                                    <option selected disabled value="">Selecione um Cargo</option>
                                                    @foreach ($cargos as $cargo)
                                                        <option value="{{ $cargo->id }}"> {{ $cargo->nome }}</option>    
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 mb-3">
                                            <label for="biografia" class="form-label">Biografia</label>
                                            <textarea class="form-control" id="biografia" name="biografia" rows="8" placeholder="Digite a Biografia" maxlength="2200" required></textarea>
                                            <small id="counterBio" class="form-text text-muted mt-1">0 / 2200 caracteres</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <footer class="card-footer text-end">
                            <a href="{{ route('membros-comissao.index') }}" class="btn btn-dark">Voltar</a>
                            <button class="btn btn-warning">Submeter</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>

        <!-- end: page -->
    </section>
    <script src="{{ asset("admin/js/Validacao/membroComissao.js")}}"></script>
@endsection

    
