@extends('admin.layouts.platform')

@section('title', 'Estrutura Orgânica')

@section('subtitle','Detalhes')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Estrutura Orgânica</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Detalhes da Estrutura Orgânica</h2>
                </header>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 text-center">
                            <div>
                                <h5 class="mb-3">iMAGEM do Orgânica</h5>
                                <img src="{{ $estrutura->img_organigrama ? asset('admin/imagens/estruturaOrganica/'.$estrutura->img_organigrama) : asset('admin/imagens/users/default.png') }}" 
                                     class="border border-3 mb-3"
                                     style="width: 230px; height: 300px; background-repeat: no-repeat; background-size: cover;"  
                                     alt="Foto do organigrama">
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="row">
                                <div class="col-lg-8 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="titulo">Titulo</label>
                                        <input type="text" class="form-control" id="titulo" value="{{ $estrutura->titulo ?? '' }}" name="titulo" placeholder="Digite o titulo" readonly>
                                    </div>
                                </div>

                                <div class="col-lg-4 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="estado">Estado</label>
                                        <input type="text" class="form-control" id="estado" name="estado" value="{{ $estrutura->estado ? 'Activo' : 'Inativo'}}" placeholder="Digite o número de telefone" readonly>
                                    </div>
                                </div>

                                <div class="col-lg-12 mb-3">
                                    <label for="descricao" class="col-form-label">Descrição</label>
                                    <textarea class="form-control" id="descricao" name="descricao" rows="8" placeholder="Digite a descrição" readonly>{{ $estrutura->descricao ?? '' }}</textarea>
                                    {{-- <small id="counterResumo" class="form-text text-muted mt-1">0 / 315 caracteres</small> --}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="card-footer text-end">
                    <a href="{{ route('estrutura-organica.index') }}" class="btn btn-dark">Voltar</a>
                    <a href="{{ route('estrutura-organica.edit', encrypt($estrutura->id)) }}" class="btn btn-warning">Editar</a>
                </footer>
            </section>
        </div>
    </div>
    <!-- end: page -->
</section>
@endsection
