@extends('admin.layouts.platform')

@section('title', 'Estrutura Orgânica')

@section('subtitle','Editar')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Estrutura Orgânica</span></li>
                <li><span>Editar</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif

    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <form action="{{ route('estrutura-organica.update', encrypt($estrutura->id)) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h2 class="card-title">Editar Estrutura Orgânica</h2>
                    </header>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-4 text-center d-flex align-items-center justify-content-center">
                                <div>
                                    <h5 class="mb-3">Atualizar Imagem do Organigrama</h5>
                                    <div class="position-relative">
                                        <img id="imagePreview" src="{{ $estrutura->img_organigrama ? asset('admin/imagens/estruturaOrganica/'.$estrutura->img_organigrama) : asset('admin/imagens/users/default.png') }}" 
                                            class="border border-3 mb-3"
                                            style="width: 230px; height: 300px; background-repeat: no-repeat; background-size: cover;"  
                                            alt="Preview">
                                    </div>
                                    <label for="imageUpload" class="btn btn-primary">Selecionar Imagem</label>
                                    <input type="file" id="imageUpload" accept="image/*" name="foto" 
                                           class="form-control d-none" onchange="previewImage(event)">
                                </div>
                            </div>

                            <div class="col-lg-8">
                                <div class="row">
                                    <input type="hidden" class="form-control" name="id" value="{{ $estrutura->id }}">
                                    <div class="col-lg-8 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="titulo">Titulo</label>
                                            <input type="text" class="form-control" id="titulo" value="{{ $estrutura->titulo ?? '' }}" name="titulo" placeholder="Digite o titulo" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 mb-3">
                                        <label for="estado" class="col-form-label">Estado</label>
                                        <select class="form-select" id="estado" name="estado" required>
                                            <option value="" disabled selected>Selecione um</option>
                                                <option value="1" {{ $estrutura->estado ? 'selected' : '' }}>Activo</option>
                                                <option value="0" {{ !$estrutura->estado ? 'selected' : '' }}>Inativo</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="descricao" class="col-form-label">Descrição</label>
                                        <textarea class="form-control" id="descricao" name="descricao" rows="8" placeholder="Digite a descrição" required>{{ $estrutura->descricao ?? '' }}</textarea>
                                        {{-- <small id="counterResumo" class="form-text text-muted mt-1">0 / 315 caracteres</small> --}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <footer class="card-footer text-end">
                        <a href="{{ route('estrutura-organica.index') }}" class="btn btn-dark">Voltar</a>
                        <button type="submit" class="btn btn-warning">Salvar Alterações</button>
                    </footer>
                </section>
            </div>
        </form>
    </div>
    <!-- end: page -->
</section>

<script src="{{ asset("admin/js/Validacao/estruturaOrganica.js")}}"></script>
@endsection