@extends('admin.layouts.platform')

@section('title', 'Sobre')
@section('subtitle','Configurações')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>Dashboard</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Configurações</span></li>
                <li><span>Sobre</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>

    {{-- MENSAGENS DE ERRO/SUCESSO --}}
    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `<ul>@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>`,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif

    @if (session('success'))
        <script>
            Swal.fire({
                title: 'Sucesso',
                icon:'success',
                text: '{{ session('success') }}',
                confirmButtonText: 'Fechar'
            })
        </script>
    @endif

    {{-- FORMULÁRIO --}}
    <div style="padding-top: 80px;">
        <form action="{{ route('sobre.store') }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <h2 class="card-title">Informações da Seção "Sobre"</h2>
                        </header>
                        <div class="card-body">
                            <div class="col-lg-12">
                                <label for="estado" class="form-label">Estado</label>
                                <select class="form-select" id="estado" name="estado" required>
                                    <option value="1" {{ $dado->estado ? 'selected' : '' }}>Activo</option>
                                    <option value="0" {{ !$dado->estado ? 'selected' : '' }}>Inativo</option>
                                </select>
                            </div>  
                            <hr>
                            <div class="form-group">
                                <h3 for="sobre">Conteúdo da Seção Sobre</h3>
                                <textarea name="conteudo" id="sobre" class="form-control" rows="15">{{ old('sobre', $dado->conteudo ?? '') }}</textarea>
                            </div>
                        </div>
                        <footer class="card-footer text-end">
                            <button class="btn btn-warning">Salvar</button>
                        </footer>
                    </section>
                </div>
            </div>
        </form>
    </div>
</section>

{{-- TinyMCE --}}
<script src="{{ asset('tinymceEditor/js/tinymce/tinymce.min.js') }}"></script>
<script>
    tinymce.init({
        selector: 'textarea#sobre',
        height: 400,
        menubar: true,
        license_key: 'gpl',
        plugins: 'advlist autolink lists link charmap preview anchor searchreplace visualblocks code fullscreen insertdatetime table wordcount',
        toolbar: 'undo redo | formatselect | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | preview',
        branding: false,

        content_style: `
            body {
                font-family: Arial, sans-serif;
                font-size: 16px;
                line-height: 1.4;
                color: #333;
            }

            p {
                margin: 0 0 7px 0;
            }

            ul, ol {
                color: #333;
                margin: 0 0 10px 20px;
            }

            li {
                color: black;
                margin-bottom: 5px;
            }
        `
        
    });
</script>
@endsection
