@extends('admin.layouts.platform')

@section('title', 'Carrossel (Boas vindas)')

@section('subtitle','Registro')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Configurações</span></li>
                    <li><span>Entidade</span></li>
                    <li><span>Carrossel (Boas vindas)</span></li>
                    <li><span>Registro</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('carrossel.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                            </div>
                            <h2 class="card-title">Registro de um Novo Item no Carrossel</h2>
                            {{-- <p class="card-subtitle">
                                Este é um exemplo de formulário com múltiplos campos organizados em colunas.
                            </p> --}}
                        </header>

                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-4 text-center d-flex justify-content-center">
                                    <div class="row">
                                        <span>Imagem</span>
                                        <label for="imageUpload" class="cursor-pointer" title="Clique para escolher a imagem">
                                            <div class="position-relative">
                                                <!-- Preview da imagem -->
                                                <img id="imagePreview" src="{{ asset('admin/img/logo.png')}}" 
                                                    class=" border border-3 m-1" 
                                                {{-- class="rounded-circle border border-3 mb-3"  --}}
                                                    style="width: 300px; height: 200px; object-fit: fill;" 
                                                    alt="imagem ">
                                            </div>
                                        <!-- Botão de seleção -->
                                        </label>
                                        <input type="file" id="imageUpload" accept="image/jpeg,image/jpg,image/png"  name="imagem" required
                                            class="form-control d-none" onchange="previewImage(event)">

                                    </div>
                                </div>

                                <!-- Coluna dos Inputs -->
                                <div class="col-lg-8">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <label for="titulo" class="form-label">Lema</label>
                                                <input type="text" class="form-control" id="nome" maxlength="50" name="lema" placeholder="Digite o lema" >
                                                <small id="counterTitulo" class="form-text text-muted mt-1">0 / 50 caracteres</small>
                                            </div>
                                        </div>
                                        <div class="col-lg-12">
                                            <label for="estado" class="form-label">Estado </label>
                                            <select class="form-select" id="estado" name="estado" required>
                                                <option value="" disabled selected>Selecione o estado</option>
                                                <option value="1">Activo</option>
                                                <option value="0">Inativo</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>                            
                            </div>
                        </div>

                        <footer class="card-footer text-end">
                            <a href="{{ route('carrossel.index') }}" class="btn btn-dark">Voltar</a>
                            <button class="btn btn-warning">Submeter</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>

        <!-- end: page -->
    </section>

    <script src="{{ asset("admin/js/Validacao/bunner.js")}}"></script>
@endsection