@extends('admin.layouts.platform')

@section('title', 'Bunner')

@section('subtitle', 'Detalhes')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>Detalhes do Item do Bunner</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Configurações</span></li>
                <li><span>Entidade</span></li>
                <li><span>Bunner Slide</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>

    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Visualização do Item do Bunner</h2>
                </header>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 text-center d-flex justify-content-center">
                            <div class="row">
                                <label for="imageUpload" title="Logo">
                                    <div class="position-relative">
                                        <!-- Preview da imagem -->
                                        <img id="imagePreview" 
                                            src="{{ $bunner->imagem ? asset('admin/endidadesIMG/bunnerSlide/' . $bunner->imagem) : asset('admin/img/logo.png') }}" 
                                            class=" border border-3 m-1" 
                                        {{-- class="rounded-circle border border-3 mb-3"  --}}
                                            style="width: 300px; height: 200px; object-fit: fill;" 
                                            alt="Imagem">
                                    </div>
                                    <!-- Botão de seleção -->
                                </label>
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <div class="row">
                               <div class="col-lg-12 mb-3">
                                    <label for="titulo" class="form-label">Titulo</label>
                                    <input type="text" class="form-control" id="nome" maxlength="60" name="nome" value="{{ $bunner->titulo ?? 'S/N' }}" placeholder="Digite o nome" readonly>
                                </div>
                                <div class="col-md-4">
                                    <label>Cor do titulo</label>
                                    <div class="d-flex align-items-center gap-2">
                                        <input type="color" id="cor" name="cor" class="form-control form-control-color" readonly>
                                        <div id="preview_cor" style="width: 40px; height: 40px; border-radius: 5px; border: 1px solid #ccc; background-color: {{$bunner->cor_titulo}};"></div>
                                    </div>
                                </div>

                                <div class="col-lg-4">
                                        <label for="fixo" class="form-label">Imagem Fixa? </label>
                                        <select class="form-select" id="fixo" name="fixo" disabled>
                                            <option value="1" {{ $bunner->isFixo ? 'selected' : '' }}>Sim</option>
                                            <option value="0" {{ !$bunner->isFixo ? 'selected' : '' }}>Não</option>
                                        </select>
                                    </div>

                                <div class="col-lg-4">
                                    <label for="estado" class="form-label">Estado</label>
                                    <select class="form-select" id="estado" name="estado" disabled>
                                        <option value="1" {{ $bunner->estado ? 'selected' : '' }}>Activo</option>
                                        <option value="0" {{ !$bunner->estado ? 'selected' : '' }}>Inativo</option>
                                    </select>
                                </div> 
                                
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="card-footer text-end">
                    <a href="{{ route('bunner.index') }}" class="btn btn-dark">Voltar</a>
                    <a href="{{ route('bunner.edit', encrypt($bunner->id)) }}" class="btn btn-warning">Editar</a>
                </footer>
            </section>
        </div>
    </div>
</section>
@endsection
