@extends('admin.layouts.platform')

@section('title', 'Dados de Contacto')

@section('subtitle','Detalhes')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Configurações</span></li>
                    <li><span>Dados de Contacto</span></li>
                    <li><span>Detalhes</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->

        <div class="row" style="padding-top: 80px;">
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <div class="card-actions"></div>
                        <h2 class="card-title">Detalhes dos Dados de Contacto</h2>
                    </header>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="emailGeral">Email Geral</label>
                                            <input type="email" class="form-control" id="emailGeral" value="{{ $contacto->emailGeral ?? '' }}" name="emailGeral" placeholder="Digite o email" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="emailSuporte">Email de Suporte</label>
                                            <input type="text" class="form-control" id="emailSuporte" value="{{ $contacto->emailSuporte ?? '' }}" name="emailSuporte" placeholder="Digite o email" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="endereco">Endereço</label>
                                            <input type="text" class="form-control" id="endereco" value="{{ $contacto->endereco ?? '' }}" name="endereco" placeholder="Digite o endereço" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="telefone">Telefone</label>
                                            <input type="text" class="form-control" id="telefone" value="{{ $contacto->telefone ?? '' }}" name="telefone" placeholder="Digite o telefone" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label class="col-form-label" for="estado">Estado</label>
                                            <input type="text" class="form-control" id="estado" name="estado" 
                                                    value="{{ $contacto->estado ? 'Ativo' : 'Inativo' }}" 
                                                    placeholder="Digite o subtítulo" readonly>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="latitude">Latitude</label>
                                            <input type="text" class="form-control" id="latitude" value="{{ $contacto->latitude ?? '' }}" name="latitude" placeholder="Digite a latitude" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="longitude">Longitude</label>
                                            <input type="text" class="form-control" id="longitude" value="{{ $contacto->longitude ?? '' }}" name="longitude" placeholder="Digite a longitude" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <footer class="card-footer text-end">
                        <a href="{{ route('contactos-portal.index') }}" class="btn btn-dark">Voltar</a>
                        <a href="{{ route('contactos-portal.edit', encrypt($contacto->id)) }}" class="btn btn-warning">Editar</a>
                    </footer>
                </section>
            </div>
        </div>        
        <!-- end: page -->
    </section>
@endsection

    