@extends('admin.layouts.platform')

@section('title', 'Dados de Contacto')

@section('subtitle','Registro')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Configurações</span></li>
                    <li><span>Dados de Contacto</span></li>
                    <li><span>Registro</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('contactos-portal.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                            </div>
                            <h2 class="card-title">Registro de novos Dados de Contacto</h2>
                        </header>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="row">
                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="emailGeral">Email Geral</label>
                                                <input type="email" class="form-control" id="emailGeral" name="emailGeral" placeholder="Digite o email" required>
                                            </div>
                                        </div>

                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="emailSuporte">Email de Suporte</label>
                                                <input type="text" class="form-control" id="emailSuporte" name="emailSuporte" placeholder="Digite o email" required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-lg-12 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="endereco">Endereço</label>
                                                <input type="text" class="form-control" id="endereco" name="endereco" placeholder="Digite o endereço" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="telefone">Telefone</label>
                                                <input type="text" class="form-control" id="telefone" name="telefone" placeholder="Digite o telefone">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="estado">Estado</label>
                                                <select class="form-control" id="estado" name="estado" required>
                                                    <option value="" selected disabled>Selecione o estado</option>
                                                    <option value="1">Ativo</option>
                                                    <option value="0">Inativo</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="latitude">Latitude</label>
                                                <input type="text" class="form-control" id="latitude" name="latitude" placeholder="Digite a latitude" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="longitude">Longitude</label>
                                                <input type="text" class="form-control" id="longitude" name="longitude" placeholder="Digite a longitude" required>
                                            </div>
                                        </div>                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <footer class="card-footer text-end">
                            <a href="{{ route('contactos-portal.index') }}" class="btn btn-dark">Voltar</a>
                            <button type="submit" class="btn btn-warning">Submeter</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>
        <!-- end: page -->
    </section>
    <script src="{{ asset("admin/js/Validacao/dadosContacto.js")}}"></script>
@endsection

    