@extends('admin.layouts.platform')

@section('title', 'Categoria de Benefícios')

@section('subtitle','Editar')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Configurações</span></li>
                <li><span>Categoria de Benefícios</span></li>
                <li><span>Editar</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif

    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <form action="{{ route('categoria-de-beneficio.update', encrypt($categoria->id)) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h2 class="card-title">Editar Categoria de Benefícios</h2>
                    </header>
                    <div class="card-body">
                        <div class="row">            
                            <!-- Coluna dos Inputs -->
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-lg-8 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="nome">Nome da Categoria</label>
                                            <input type="text" class="form-control" id="nome" name="nome" value="{{ $categoria->nome ?? ''}}" placeholder="Digite o nome da categoria" required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-4 mb-3">
                                        <label for="estado" class="col-form-label">Estado</label>
                                        <select class="form-select" id="estado" name="estado" required>
                                            <option value="" disabled selected>Selecione o estado</option>
                                            <option value="1" {{ $categoria->estado ? 'selected' : '' }}>Activo</option>
                                            <option value="0" {{ !$categoria->estado ? 'selected' : '' }}>Inativo</option>
                                        </select>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                    <footer class="card-footer text-end">
                        <a href="{{ route('categoria-de-beneficio.index') }}" class="btn btn-dark">Voltar</a>
                        <button type="submit" class="btn btn-warning">Salvar Alterações</button>
                    </footer>
                </section>
            </div>
        </form>
    </div>
</section>

<script src="{{ asset("admin/js/Validacao/categoriaBeneficio.js")}}"></script>
@endsection