@extends('admin.layouts.platform')

@section('title', 'Cargos')

@section('subtitle','Listagem')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Configurações</span></li>
                    <li><span>Cargos</span></li>
                    <li><span>Listagem</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        
        @if (session('success'))
            <script>
                Swal.fire({
                    title: 'Sucesso',
                    icon:'success',
                    text: '{{ session('success') }}',
                    confirmButtonText: 'Fechar'
                })
            </script>
        @endif

        <!-- start: page -->
        <div class="row" style="padding-top: 80px;">
            <div class="col">
                <section class="card">
                    <header class="card-header">
                        <div class="card-actions">
                            {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a> --}}
                        </div>
                        <h2 class="card-title">Listagem de Cargos</h2>
                    </header>
                    <div class="card-body">
                        {{-- <div class="row">
                            <div class="col-sm-6">
                                <div class="mb-3">
                                </div>
                            </div>
                        </div> --}}
                        <table class="table table-bordered table-striped mb-0" id="datatable-tabletools">
                            <thead>
                                <a id="addToTable" href="{{ route('cargo.create')}}" class="btn btn-dark">Adicionar Novo Cargo <i class="fas fa-plus"></i></a>
                                <tr>
                                    <th>#</th>
                                    <th>Nome </th>
                                    <th>Principal </th>
                                    <th>Estado</th>
                                    <th>Acção</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($cargos as $cargo)
                                    <tr>
                                        <td> {{ $loop->index + 1 }}</td>
                                        <td>{{ $cargo->nome ?? '' }}</td>
                                        @if ($cargo->principal)
                                            <td><span class="badge badge-success">Sim</span></td>
                                        @else
                                            <td><span class="badge badge-warning">Não</span></td>
                                        @endif
                                        @if ($cargo->estado)
                                            <td><span class="badge badge-success">Activo</span></td>
                                        @else
                                            <td><span class="badge badge-warning">Inativo</span></td>
                                        @endif
                                        <td class="actions">
                                            <a href="{{ route('cargo.show', encrypt($cargo->id))}}"><i class="fa-solid fa-eye"></i></a>
                                            <a href="{{ route('cargo.edit', encrypt($cargo->id))}}"><i class="fas fa-pencil-alt"></i></a>
                                            @if(!Gate::allows('isEditor'))
                                                <a class="mb-1 mt-1 me-1 modal-basic" href="#modalEliminar{{$cargo->id}}"><i class="far fa-trash-alt"></i></a>
                                            @endif
                                        </td>


                                        <div id="modalEliminar{{$cargo->id}}" class="modal-block modal-block-danger mfp-hide">
                                            <section class="card">
                                                <header class="card-header">
                                                    <h2 class="card-title">AVISO!</h2>
                                                </header>
                                                <div class="card-body">
                                                    <div class="modal-wrapper">
                                                        <div class="modal-icon">
                                                            <i class="fas fa-times-circle"></i>
                                                        </div>
                                                        <div class="modal-text">
                                                            <h4 class="font-weight-bold text-dark">AVISO</h4>
                                                            <p>Deseja realmente eliminar este Cargo?</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <form action="{{ route('cargo.destroy', encrypt($cargo->id))}}" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <footer class="card-footer">
                                                        <div class="row">
                                                            <div class="col-md-12 text-end">
                                                                <button class="btn btn-primary modal-dismiss">Cancelar </button>
                                                                <button type="submit" class="btn btn-danger">Sim, Elimine-o</button>
                                                            </div>
                                                        </div>
                                                    </footer>
                                                </form>
                                            </section>
                                        </div>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>

        <!-- end: page -->
    </section>
@endsection

    

@section('javascript')


@endsection