@extends('admin.layouts.platform')

@section('title', 'Cargos')

@section('subtitle','Editar')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Configurações</span></li>
                <li><span>Cargos</span></li>
                <li><span>Editar</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif

    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <form action="{{ route('cargo.update', encrypt($cargo->id)) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h2 class="card-title">Editar Cargo</h2>
                    </header>
                    <div class="card-body">
                        <div class="row">            
                            <!-- Coluna dos Inputs -->
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="nome">Nome do Cargo</label>
                                            <input type="text" class="form-control" id="nome" value="{{ $cargo->nome ?? ''}}" name="nome" placeholder="Digite o nome do cargo" required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-6 mb-3">
                                        <label for="estado" class="col-form-label">Estado</label>
                                        <select class="form-select" id="estado" name="estado" required>
                                            <option value="" disabled selected>Selecione o estado</option>
                                            <option value="1" {{ $cargo->estado ? 'selected' : '' }}>Activo</option>
                                            <option value="0" {{ !$cargo->estado ? 'selected' : '' }}>Inativo</option>
                                        </select>
                                    </div>

                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="descricao">Descrição</label>
                                            <input type="text" class="form-control" id="descricao" value="{{ $cargo->descricao ?? ''}}" name="descricao" placeholder="Digite o Descrição">
                                        </div>
                                    </div>

                                    <div class="col-lg-6 mb-3">
                                        <label for="estado" class="col-form-label">Cargo Principal?</label>
                                        <select class="form-select" id="principal" name="principal" required>
                                            <option value="" disabled selected>Selecione um</option>
                                            <option value="1" {{ $cargo->principal ? 'selected' : '' }}>Sim</option>
                                            <option value="0" {{ !$cargo->principal ? 'selected' : '' }}>Não</option>
                                        </select>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                    <footer class="card-footer text-end">
                        <a href="{{ route('cargo.index') }}" class="btn btn-dark">Voltar</a>
                        <button type="submit" class="btn btn-warning">Salvar Alterações</button>
                    </footer>
                </section>
            </div>
        </form>
    </div>
</section>

<script src="{{ asset("admin/js/Validacao/cargo.js")}}"></script>
@endsection