@extends('admin.layouts.platform')

@section('title', 'Benefícios')

@section('subtitle','Registro')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Benefícios</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>

    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Detalhes do Benefício</h2>
                </header>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="row">
                                <div class="col-lg-12 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="nomeCompleto">Benefício</label>
                                        <input type="text" class="form-control" id="beneficio" value="{{ $beneficio->nome ?? ''}}" name="beneficio" placeholder="Digite o Benefício" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="username">Descrição</label>
                                        <input type="text" class="form-control" id="descricao" value="{{ $beneficio->descricao ?? ''}}" name="descricao" placeholder="Digite a Descrição" readonly>
                                    </div>
                                </div>

                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="estado">Estado</label>
                                        <input type="text" class="form-control" id="estado" name="estado" value="{{ $beneficio->estado ? 'Activo' : 'Inativo'}}" placeholder="Digite o estado" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="col-form-label" for="categoria">Categoria do Benefício</label>
                                        <input type="text" class="form-control" id="categoria" name="categoria" value="{{ $beneficio->categoriaBeneficios->nome ?? ''}}" placeholder="Digite a categoria do parceiro" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="card-footer text-end">
                    <a href="{{ route('beneficio.index') }}" class="btn btn-dark">Voltar</a>
                    <a href="{{ route('beneficio.edit', encrypt($beneficio->id))  }}" class="btn btn-warning">Editar</a>
                </footer>
            </section>
        </div>
    </div>
</section>

{{-- <script src="{{ asset("admin/js/Validacao/parceiro.js")}}"></script> --}}
@endsection