@extends('admin.layouts.platform')

@section('title', 'Log Sms Detalhes')

@section('subtitle', 'Detalhes')

@section('conteudo')
    <section role="main" class="content-body">
        <header class="page-header">
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin') }}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Auditória</span></li>
                    <li><span>Logs</span></li>
                    <li><span>Sms</span></li>
                    <li><span>Detalhes</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
       
        <!-- start: page -->
        <div class="row" style="padding-top: 80px;">
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h2 class="card-title">Detalhes do Log de SMS</h2>
                    </header>
                    <div class="card">
                        <div class="card-body">
                            <h5><strong>Telefone:</strong> {{ $log->telefone ?? "" }}</h5>
                            {{-- <p><strong>Emissor:</strong> {{ $log->email_emissor ?? "" }}</p>
                            <p><strong>Receptor:</strong> {{ $log->email_receptor ?? "" }}</p> --}}
                            <p><strong>Corpo do Mensagem:</strong></p>
                            <textarea class="bg-light p-3 w-100 mw-100 text-justify text-break">{{ $log->mensagem ?? "" }}</textarea>

                            <hr>

                            <h5><strong>Detalhes do Envio:</strong></h5>
                            <p><strong>Status:</strong>
                                @if ($log->estado == 0)
                                    <span class="badge bg-warning">PENDENTE</span>
                                @elseif ($log->estado == 1)
                                    <span class="badge bg-success">ENVIADO</span>
                                @else
                                    <span class="badge bg-danger">NÃO ENVIADO</span>
                                @endif
                            </p>
                            <p><strong>Tentativas:</strong> {{ $log->tentativas ?? "" }}</p>
                            <p><strong>Data da Tentativa:</strong> {{ $log->enviado_em ?? "" }}</p>

                            <hr>

                            <h5><strong>Erro (se houver):</strong></h5>
                            @if ($log->erro )
                                <textarea class="bg-light p-3 w-100 mw-100 text-justify text-break">{{ $log->erro ?? "" }}</textarea>
                            @else
                                <p class="text-muted">Nenhum erro registrado.</p>
                            @endif
                        </div>
                    </div>
                    <footer class="card-footer text-end d-flex gap-1 align-items-center">
                        <a href="{{ route('logs-sms.index') }}" class="btn btn-dark ms-auto">Voltar</a>
                        {{-- <form action="{{ route('reenviar', encrypt($log->id)) }}" method="POST">
                            @csrf
                            <button type="submit" class="btn btn-warning">Reenviar E-mail</button>
                        </form> --}}
                    </footer>
                    {{-- <a href="{{ route('utilizadors.edit', encrypt($utilizador->id)) }}" class="btn btn-warning">Editar</a> --}}
                </section>
            </div>
        </div>
        <!-- end: page -->
    </section>
@endsection
