@extends('admin.layouts.platform')

@section('title', 'Logs Email')

@section('subtitle','Listagem')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Auditória</span></li>
                    <li><span>Logs</span></li>
                    <li><span>SMS</span></li>
                    <li><span>Listagem</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        @if (session('success'))
            <script>
                Swal.fire({
                    title: 'Sucesso',
                    icon:'success',
                    text: '{{ session('success') }}',
                    confirmButtonText: 'Fechar'
                })
            </script>
        @endif
        
        @if (session('error'))
            <script>
                Swal.fire({
                    title: 'Aviso',
                    icon:'warning',
                    text: '{{ session('error') }}',
                    confirmButtonText: 'Fechar'
                })
            </script>
        @endif

        @if (session('warning'))
            <script>
                Swal.fire({
                    title: 'Aviso',
                    icon:'warning',
                    text: '{{ session('warning') }}',
                    confirmButtonText: 'Fechar'
                })
            </script>
        @endif
        <!-- start: page -->
        <div class="row" style="padding-top: 80px;">
            <div class="col">
                <section class="card">
                    <header class="card-header">
                        <div class="card-actions">
                            {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a> --}}
                        </div>
                        <h2 class="card-title">Listagem de Logs de SMS</h2>
                    </header>
                    <div class="card-body">
                        {{-- <div class="row">
                            <div class="col-sm-6">
                                <div class="mb-3">
                                </div>
                            </div>
                        </div> --}}
                        <table class="table table-bordered table-striped mb-0" id="datatable-tabletools">
                            <thead>
                                @endif
                                <tr>
                                    <th>#</th>
                                    <th>Telefone</th>
                                    <th>Estado</th>
                                    <th>Data Tentativa</th>
                                    <th>Acção</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($logs as $log)
                                    <tr>
                                        <td> {{ $loop->index + 1 }}</td>
                                        <td> {{ $log->telefone ?? ''}} </td>
                                        <td> {{ $log->email_receptor ?? '' }} </td>
                                        @if ($log->estado == 0)
                                            <td><span class="badge badge-warning">PENDENTE</span></td>
                                        @elseif ($sms->estado == 1)
                                            <td><span class="badge badge-success">ENVIADO</span></td>
                                        @else
                                            <td><span class="badge badge-danger">NÃO ENVIADO</span></td>
                                        @endif
                                        <td> {{ $log->enviado_em ?? '' }} </td>
                                        <td class="actions">
                                            <a href="{{ route('logs-sms.show', encrypt($log->id))}}"><i class="fa-solid fa-eye"></i></a>                                           
                                        </td>
                                    </tr>   
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </section>

    {{-- <div id="modalReenviarEmail" class="modal-block modal-block-warning mfp-hide">
        <section class="card">
            <header class="card-header">
                <h2 class="card-title">AVISO!</h2>
            </header>
            <div class="card-body">
                <div class="modal-wrapper">
                    <div class="modal-icon">
                        <i class="fas fa-times-circle"></i>
                    </div>
                    <div class="modal-text">
                        <h4 class="font-weight-bold text-dark">AVISO</h4>
                        <p>Deseja realmente Reenviar Todos os Emails?</p>
                    </div>
                </div>
            </div>
            <form action="{{ route('reenviar.emais.naoEnviados')}}" method="post">
                @csrf
                <footer class="card-footer">
                    <div class="row">
                        <div class="col-md-12 text-end">
                            <button class="btn btn-dark modal-dismiss">Cancelar </button>
                            <button type="submit" class="btn btn-warning">Sim, Reenvie</button>
                        </div>
                    </div>
                </footer>
            </form>
        </section>
    </div> --}}
    
@endsection
