@extends('admin.layouts.platform')

@section('title', 'Logs Gerais')

@section('subtitle','Detalhes')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Auditória</span></li>
                <li><span>Logs</span></li>
                <li><span>Gerais</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Detalhes do Log</h2>
                </header>
                <div class="card-body">
                    <div class="card">
                        <div class="card-header">
                            <strong>Log ID:</strong> {{ $log->id }}
                        </div>
                        <div class="card-body">
                            <p><strong>Utilizador: </strong>  {{ $log->users->name_completo ?? 'Sistema' }} - {{ $log->users->role->name ?? 'Sistema' }}</p>
                            <p><strong>Operação Realizada: </strong> 
    
                                @if ($log->evento == 'updated')
                                    {{ 'Actualização' }}
                                @elseif ($log->evento == 'created')
                                    {{ 'Inserção' }}
                                @elseif ($log->evento == 'deleted')
                                    {{ 'Delete' }}
                                @endif
                            
                            </p>
                            <p><strong>Data da Operação: </strong> {{ $log->data_registo }}</p>
                            <p><strong>Endereço IP: </strong> {{ $log->endereco_ip ?? 'N/A' }}</p>
                            <p id="ent-euditada" hidden><strong>Entidade Auditada: </strong> {{ $log->auditable_type }} (ID: {{ $log->auditable_id }}) </p> <p class="text-danger" onclick="toggleEntidade()" id="troca">Mostrar Entidade</p>
                            <p><strong>Descrição:</strong> {{ $log->descricao }}</p>
                
                            <h4>Alterações</h4>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Campo</th>
                                            <th>Valor Antigo</th>
                                            <th>Valor Novo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $oldData = json_decode($log->old_data, true);
                                            $newData = json_decode($log->new_data, true);
                                        @endphp
                
                                        @if($oldData && $newData)
                                            @foreach($newData as $key => $value)
                                                <tr>
                                                    <td>{{ $key }}</td>
                                                    <td>{{ $oldData[$key] ?? 'N/A' }}</td>
                                                    <td>{{ $value }}</td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td colspan="3" class="text-center">Nenhuma alteração registrada.</td>
                                            </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>        
                </div>
                <footer class="card-footer text-end">
                    <a href="{{ route('auditoria-geral.index') }}" class="btn btn-dark">Voltar</a>
                    {{-- <a href="{{ route('utilizadors.edit', encrypt($utilizador->id)) }}" class="btn btn-warning">Editar</a> --}}
                </footer>
            </section>
        </div>
    </div>
    <!-- end: page -->
</section>
@endsection
