@extends('admin.layouts.platform')

@section('title', 'Legislação')

@section('subtitle','Detalhes')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Documentos Legislativos</span></li>
                    <li><span>Detalhes</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->

        <div class="row" style="padding-top: 80px;">
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <div class="card-actions"></div>
                        <h2 class="card-title">Detalhes do Documento Legislativo</h2>
                    </header>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="row">
                                    <!-- Campo Título -->
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="titulo">Título</label>
                                            <input type="text" class="form-control" id="titulo" name="titulo" 
                                                    value="{{ $legislacao->titulo ?? '' }}" 
                                                    placeholder="Digite o título" readonly>
                                        </div>
                                    </div>
    
                                    <!-- Campo Subtítulo -->
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label class="col-form-label" for="subtitulo">Subtítulo</label>
                                            <input type="text" class="form-control" id="subtitulo" name="subtitulo" 
                                                    value="{{ $legislacao->subTitulo ?? '' }}" 
                                                    placeholder="Digite o subtítulo" readonly>
                                        </div>
                                    </div>
    

                                    <!-- Campo Estado -->
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label class="col-form-label" for="subtitulo">Estado</label>
                                            <input type="text" class="form-control" id="estado" name="estado" 
                                                    value="{{ $legislacao->estado ? 'Ativo' : 'Inativo' }}" 
                                                    placeholder="Digite o subtítulo" readonly>
                                        </div>
                                    </div>
    
                                    <!-- Campo Documento -->
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label class="col-form-label" for="subtitulo">Documento</label>
                                            <div>
                                                @if ($legislacao->anexo)
                                                    <a class="btn btn-dark" href="{{ asset('admin/documentos/legislacao/' . $legislacao->anexo) }}" download>Ver Documento</a>
                                                @endif
                                            </div>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <footer class="card-footer text-end">
                        <a href="{{ route('legislacoes.index') }}" class="btn btn-dark">Voltar</a>
                        <a href="{{ route('legislacoes.edit', encrypt($legislacao->id)) }}" class="btn btn-warning">Editar</a>
                    </footer>
                </section>
            </div>
        </div>
        
        
        <!-- end: page -->
    </section>
    {{-- <script src="{{ asset("admin/js/Validacao/role.js")}}"></script> --}}
@endsection

    