const inputFileDeclaracao = document.getElementById('arquivo_declaracao');
const fileNameDisplayDeclaracao = document.getElementById('file-name-declaracao');


function toggleOrgao(element) {
    const declaracaoOrgaoCentral = document.getElementById('decOrgaoCentral');
    const declaracaoOutraEntidade = document.getElementById('decOutraEntidade');
    if (element.value === '1') {
        declaracaoOrgaoCentral.style.display = 'block';
        declaracaoOutraEntidade.style.display = 'none';
    }else {
        declaracaoOrgaoCentral.style.display = 'none';
        declaracaoOutraEntidade.style.display = 'block';
    }
}

// Quando o checkbox for marcado
document.getElementById('termos-aceite').addEventListener('change', function () {
    // Habilitar o botão de submeter se o checkbox estiver marcado
    document.getElementById('submeter').disabled = !this.checked;
});

document.addEventListener('DOMContentLoaded', function() {
    // Selecione o modal e o checkbox
    const termosModal = document.getElementById('termosModal');
    const termosCheckbox = document.getElementById('termos-aceite');

    // Detecte quando o modal for exibido
    termosModal.addEventListener('shown.bs.modal', function() {
        // Habilita o checkbox após o modal ser exibido
        termosCheckbox.disabled = false;
    });


});

// function formatarSalario(element) {
//     // Remove todos os caracteres que não sejam números
//     let valor = element.value.replace(/\D/g, '');

//     // Verifica se o valor é um número válido
//     if (isNaN(valor) || valor === '') {
//         element.setCustomValidity(" ");
//         element.reportValidity();
//     }

//     // Adiciona as casas decimais
//     valor = (valor / 100).toFixed(2) + '';


//     element.setCustomValidity("");
//     element.value = valor;
// }

function formatarSalario(element) {
    // Remove todos os caracteres que não sejam números
    let valor = element.value.replace(/\D/g, '');

    // Verifica se o valor é um número válido
    if (isNaN(valor) || valor === '') {
        element.setCustomValidity(" ");
        element.reportValidity();
        return;
    }

    // Adiciona as casas decimais
    valor = (valor / 100).toFixed(2);

    // Formata com separadores de milhar e vírgula para decimais
    valor = valor.replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.');

    // Atualiza o campo com o valor formatado
    element.setCustomValidity("");
    element.value = String(valor);
}

inputFileDeclaracao.addEventListener('change', function() {
    if (inputFileDeclaracao.files.length > 0) {
        fileNameDisplayDeclaracao.textContent = inputFileDeclaracao.files[0].name;
    } else {
        fileNameDisplayDeclaracao.textContent = "Nenhum arquivo selecionado";
    }
});

const inputFileIdentificacao = document.getElementById('arquivo_identificacao');
const fileNameDisplayIdentificacao = document.getElementById('file-name-Identificacao');

inputFileIdentificacao.addEventListener('change', function() {
    if (inputFileIdentificacao.files.length > 0) {
        fileNameDisplayIdentificacao.textContent = inputFileIdentificacao.files[0].name;
    } else {
        fileNameDisplayIdentificacao.textContent = "Nenhum arquivo selecionado";
    }
});

document.addEventListener("DOMContentLoaded", function () {
    const steps = document.querySelectorAll(".step");
    const progressBar = document.getElementById("progress-bar");
    let currentStep = 0;

    function updateSteps() {
        steps.forEach((step, index) => {
            step.classList.toggle("d-none", index !== currentStep);
        });
        progressBar.style.width = `${((currentStep + 1) / steps.length) * 100}%`;
    }

    function validateCurrentStep() {
        const inputs = steps[currentStep].querySelectorAll("input, select, textarea");
        let isValid = true;

        inputs.forEach((input) => {
            if (!input.checkValidity()) {
                isValid = false;
                input.classList.add("is-invalid");
            } else {
                input.classList.remove("is-invalid");
            }
        });

        return isValid;
    }

    document.querySelectorAll(".next-step").forEach((button) => {
        button.addEventListener("click", () => {
            if (validateCurrentStep() && currentStep < steps.length - 1) {
                currentStep++;
                updateSteps();
            }
        });
    });

    document.querySelectorAll(".prev-step").forEach((button) => {
        button.addEventListener("click", () => {
            if (currentStep > 0) {
                currentStep--;
                updateSteps();
            }
        });
    });

    updateSteps();
});