function previewImage(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function (e) {
            document.getElementById('imagePreview').src = e.target.result;
        };
        reader.readAsDataURL(file);
    }
}

function validarTextoComAcentos(inputNome) {
    const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ0-9ºª,.´'`\s\-]+$/;

    inputNome.onkeyup = function () {
        let nomeSemEspaco = inputNome.value.trim();

        if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 5) {
            inputNome.setCustomValidity(
                "Nome inválido"
            );
            inputNome.reportValidity();
        } else {
            inputNome.setCustomValidity("");
        }
    };
}

function validarTextoParaEndereco(inputNome) {
    const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ0-9ºª,.´'`\s\-]+$/;

    inputNome.onkeyup = function () {
        let nomeSemEspaco = inputNome.value.trim();

        if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 5) {
            inputNome.setCustomValidity(
                "Nome inválido"
            );
            inputNome.reportValidity();
        } else {
            inputNome.setCustomValidity("");
        }
    };
}

function validarTelefone(inputTel) {
    const validaNumTelefone = /^((\+244[9]{1}[0-9]{8})|(\+244[222]{3}[0-9]{6})|([9]{1}[0-9]{8})|([222]{3}[0-9]{6})|(\+\d{1,3}[1-9]\d{0,14}))$/;

    inputTel.onkeyup = function () {
        let telSemEspaco = inputTel.value.trim();

        if (!validaNumTelefone.test(telSemEspaco) || telSemEspaco.length < 9) {
            inputTel.setCustomValidity(
                "Número de Telefone inválido"
            );
            inputTel.reportValidity();
        } else {
            inputTel.setCustomValidity("");
        }
    };
}

function validarSite(inputSite) {
    // const validaSite = /^(https?:\/\/)?(www\.)?[a-zA-Z0-9-]+\.[a-zA-Z]{2,}(:[0-9]{1,5})?(\/[^\s]*)?$/;
    const validaSite = /^(https?:\/\/)?(www\.)?[a-zA-Z0-9-]+(\.[a-zA-Z]{2,}){1,2}(:[0-9]{1,5})?(\/[^\s]*)?$/

    inputSite.onkeyup = function () {
        let siteSemEspaco = inputSite.value.trim();

        if (!validaSite.test(siteSemEspaco) || siteSemEspaco.length < 10) {
            inputSite.setCustomValidity(
                "Site inválido ou caracteres insuficiente (minimo 10)"
            );
            inputSite.reportValidity();
        } else {
            inputSite.setCustomValidity("");
        }
    };
}


const nomeParceiro = document.getElementById("nome");
const enderecoParceiro = document.getElementById("endereco");
const telefoneParceiro = document.getElementById("telefone");
const site = document.getElementById("site");

validarTextoComAcentos(nomeParceiro);
validarTextoParaEndereco(enderecoParceiro);
validarTelefone(telefoneParceiro);
validarSite(site);
