function previewImage(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function (e) {
            document.getElementById('imagePreview').src = e.target.result;
        };
        reader.readAsDataURL(file);
    }
}

document.addEventListener('DOMContentLoaded', function () {
    const textarea = document.getElementById('resumo');
    const counter = document.getElementById('counterResumo');
    const maxLength = textarea.getAttribute('maxlength');

    textarea.addEventListener('input', function () {
        const currentLength = textarea.value.length;
        counter.textContent = `${currentLength} / ${maxLength} caracteres`;
    });
});

document.addEventListener('DOMContentLoaded', function () {
    const titulo = document.getElementById('titulo');
    const counter = document.getElementById('counterTitulo');
    const maxLength = titulo.getAttribute('maxlength');

    titulo.addEventListener('input', function () {
        const currentLength = titulo.value.length;
        counter.textContent = `${currentLength} / ${maxLength} caracteres`;
    });
});

// function initializeCharacterCounter(inputId, counterId) {
//     document.addEventListener('DOMContentLoaded', function () {
//         const inputId = document.getElementById(inputId);
//         const counter = document.getElementById(counterId);
//         const maxLength = inputId.getAttribute('maxlength');

//         inputId.addEventListener('input', function () {
//             const currentLength = inputId.value.length;
//             counter.textContent = `${currentLength} / ${maxLength} caracteres`;
//         });
//     });
// }


function validarTextoComAcentos(inputNome) {
    // const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+)*$/;

    inputNome.onkeyup = function () {
        let nomeSemEspaco = inputNome.value.trim();
        // if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 45) {
        if (nomeSemEspaco.length < 45) {
            inputNome.setCustomValidity(
                "Texto inválido ou quantidade de caracteres insuficiente (45 no minimo)"
            );
            inputNome.reportValidity();
        } else {
            inputNome.setCustomValidity("");
        }
    };
}

function validarTextoComAcentosPontosEVirgulasResumo(inputNome) {
    // const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+)*$/;

    inputNome.addEventListener('input', function () {
        let nomeSemEspaco = inputNome.value.trim();
        if (nomeSemEspaco.length < 100) {
            inputNome.setCustomValidity("Texto inválido ou quantidade de caracteres insuficiente (100 no mínimo)");
        } else {
            inputNome.setCustomValidity("");
        }
        inputNome.reportValidity();
    });
}



function validarTextoComAcentosPontosEVirgulas(inputNome) {
    // const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+)*$/;
    
    inputNome.addEventListener('input', function () {
        let nomeSemEspaco = inputNome.value.trim();
        // if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 5) {
        if (nomeSemEspaco.length < 5) {
            inputNome.setCustomValidity("Texto inválido ou quantidade de caracteres insuficiente (5 no mínimo)");
        } else {
            inputNome.setCustomValidity("");
        }
        inputNome.reportValidity();
    });
}


const titulo = document.getElementById("titulo");
const resumo = document.getElementById("resumo");
const corpo = document.getElementById("corpo_noticia");


validarTextoComAcentos(titulo);
if (resumo && corpo) {
    validarTextoComAcentosPontosEVirgulasResumo(resumo);
    validarTextoComAcentosPontosEVirgulas(corpo);
}



