
document.addEventListener('DOMContentLoaded', function () {
    const descricao = document.getElementById('descricao');
    const counter = document.getElementById('counterDescricao');
    const maxLength = descricao.getAttribute('maxlength');

    descricao.addEventListener('input', function () {
        const currentLength = descricao.value.length;
        counter.textContent = `${currentLength} / ${maxLength} caracteres`;
    });
});



function validarTextoTextArea(inputNome) {
    // const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+)*$/;
    
    inputNome.addEventListener('input', function () {
        let nomeSemEspaco = inputNome.value.trim();
        // if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 5) {
        if (nomeSemEspaco.length < 5) {
            inputNome.setCustomValidity("Texto inválido ou quantidade de caracteres insuficiente (5 no mínimo)");
        } else {
            inputNome.setCustomValidity("");
        }
        inputNome.reportValidity();
    });
}

const descricao = document.getElementById("descricao");

if (descricao) {
    validarTextoTextArea(descricao);
}



