function previewImage(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function (e) {
            document.getElementById('imagePreview').src = e.target.result;
        };
        reader.readAsDataURL(file);
    }
}

document.addEventListener('DOMContentLoaded', function () {
    const bio = document.getElementById('biografia');
    const counter = document.getElementById('counterBio');
    const maxLength = bio.getAttribute('maxlength');

    bio.addEventListener('input', function () {
        const currentLength = bio.value.length;
        counter.textContent = `${currentLength} / ${maxLength} caracteres`;
    });
});

function validarTexto(inputNome) {
    // const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+)*$/;

    inputNome.onkeyup = function () {
        let nomeSemEspaco = inputNome.value.trim();
        // if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 45) {
        if (nomeSemEspaco.length < 5) {
            inputNome.setCustomValidity(
                "Texto inválido ou quantidade de caracteres insuficiente (5 no minimo)"
            );
            inputNome.reportValidity();
        } else {
            inputNome.setCustomValidity("");
        }
    };
}

function validarTextoTextArea(inputNome) {
    // const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d10-9.,]+)*$/;
    
    inputNome.addEventListener('input', function () {
        let nomeSemEspaco = inputNome.value.trim();
        // if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 5) {
        if (nomeSemEspaco.length < 5) {
            inputNome.setCustomValidity("Texto inválido ou quantidade de caracteres insuficiente (5 no mínimo)");
        } else {
            inputNome.setCustomValidity("");
        }
        inputNome.reportValidity();
    });
}



const nome = document.getElementById("nome");
const biografia = document.getElementById("biografia");


validarTexto(nome);
if (biografia) {
    validarTextoTextArea(biografia);
}



